<?php
session_start();
if (isset($_SESSION['username'])) {
    $username = $_SESSION['username'];
} else {
    $username = 'Guest'; // Jika tiada sesi, tetapkan kepada Guest
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings Tahun 5</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #fff; /* Light background */
            color: #333; /* Dark text color */
        }

        /* Header Section */
        .header {
            background-color: #333; /* Dark header */
            color: #fff;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-sizing: border-box;
        }

        .header .home-button {
            background-color: #fff;
            color: #333;
            border: 1px solid #ccc;
            padding: 8px 15px;
            font-size: 16px;
            cursor: pointer;
            transition: background-color 0.2s, transform 0.2s;
        }

        .header .home-button:hover {
            background-color: #f0f0f0;
        }

        .header .title {
            font-size: 20px;
        }

        /* Container Section */
        .container {
            padding: 20px;
            max-width: 800px;
            margin: 20px auto;
        }

        .title-section {
            margin-bottom: 20px;
            font-size: 18px;
            font-weight: bold;
        }

        .action-button {
            background-color: #f5f5f5; /* Light grey button */
            color: #333;
            border: 1px solid #ddd;
            padding: 12px 18px;
            font-size: 16px;
            cursor: pointer;
            width: 100%;
            margin-bottom: 15px;
            text-align: left;
            transition: background-color 0.2s, transform 0.2s;
        }

        .action-button:hover {
            background-color: #e0e0e0;
        }

        .action-button:active {
            transform: scale(0.98);
        }
    </style>
    <script>
        function sahkanPadam() {
            if (confirm("Adakah anda pasti mahu memadam akaun anda? Tindakan ini tidak boleh dibatalkan.")) {
                window.location.href = 'delete_account.php';
            }
        }

        function confirmLogout() {
            var confirmation = confirm("Adakah anda pasti mahu log keluar?");
            if (confirmation) {
                window.location.href = '../intro/LoginPelajar.php';
            }
        }
    </script>
</head>
<body>

<!-- Header with Home Button and Title -->
<div class="header">
    <button class="home-button" onclick="window.location.href='indexTahun5.php'">Home</button>
    <div class="title">Settings Tahun 5</div>
</div>

<!-- Content Section -->
<div class="container">
    <!-- Account Section -->
    <div class="title-section">Akaun</div>
    <button class="action-button" onclick="sahkanPadam()">Padam Akaun</button>
    <button class="action-button" onclick="confirmLogout()">Log Keluar</button>
    
    <!-- Profile Section -->
    <div class="title-section">Profil Pemain</div>
    <button class="action-button" onclick="window.location.href='profilsetting5.php'">
        <?php echo $username; ?>
    </button>
    
    <!-- Info Section -->
    <div class="title-section">Info</div>
    <button class="action-button" onclick="window.location.href='dasarPrivasi.php'">Dasar Privasi</button>
    <button class="action-button" onclick="window.location.href='termaPenggunaan.php'">Terma Penggunaan</button>
</div>

</body>
</html>
