<?php
session_start();
include('../intro/config.php'); // Ensure this file contains the database connection logic

// Default profile picture
$default_picture = '../profile/kucing.jpg';

// Check if the username is set in the session
$username = isset($_SESSION['username']) ? $_SESSION['username'] : null;

if (!$username) {
    header("Location: LoginPelajar.php"); // Redirect to login if not logged in
    exit();
}

// Fetch the current profile picture for the user
$sql = "SELECT profile FROM pelajar WHERE username = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param('s', $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
    $profile_picture = $user['profile'] ? $user['profile'] : $default_picture;
} else {
    // If no user found, set to default
    $profile_picture = $default_picture;
}

// Handle profile picture selection and save it to the database
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['profile_picture'])) {
    $new_profile_picture = $_POST['profile_picture'];

    $update_sql = "UPDATE pelajar SET profile = ? WHERE username = ?";
    $update_stmt = $conn->prepare($update_sql);
    $update_stmt->bind_param('ss', $new_profile_picture, $username);

    if ($update_stmt->execute()) {
        $_SESSION['profile_picture'] = $new_profile_picture;
        echo json_encode(['success' => true, 'message' => 'Profile picture updated successfully!']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Failed to update profile picture!']);
    }
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Select Profile Picture</title>
    <style>
        body {
            font-family: 'Comic Sans MS', sans-serif;
            background-color: #f0f8ff;
            text-align: center;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .header {
            background-color: #32cd32;
            padding: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            color: white;
        }

        .header h1 {
            margin: 0 auto;
            font-size: 24px;
        }

        .back-button {
            background-color: transparent;
            border: 2px solid white;
            padding: 5px 10px;
            color: white;
            cursor: pointer;
            font-size: 18px;
            text-decoration: none;
            border-radius: 5px;
        }

        .back-button:hover {
            background-color: white;
            color: #32cd32;
        }

        .container {
            margin-top: 20px;
        }

        .greeting {
            font-size: 24px;
            color: #2e8b57;
        }

        .profile-option {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(100px, 1fr));
            gap: 20px;
            justify-content: center;
            padding: 20px;
        }

        .profile-option label {
            position: relative;
            cursor: pointer;
        }

        .profile-option img {
            width: 100px;
            height: 100px;
            border-radius: 50%;
            border: 4px solid transparent;
            transition: transform 0.3s, border-color 0.3s, box-shadow 0.3s;
        }

        .profile-option img:hover {
            transform: scale(1.2);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
        }

        .profile-option input[type="radio"]:checked + img {
            border-color: #32cd32;
            box-shadow: 0 0 20px rgba(50, 205, 50, 0.8);
        }

        #preview-section {
            margin-top: 20px;
            text-align: center;
        }

        #preview-image {
            width: 150px;
            height: 150px;
            border-radius: 50%;
            border: 5px solid #32cd32;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <a href="indexTahun5.php" class="back-button">Back</a>
        <h1>Select Your Profile Picture</h1>
    </div>

    <!-- Main Container -->
    <div class="container">
        <p class="greeting">Hey, <?php echo htmlspecialchars($username); ?>! Let's change your looks! Pick an avatar below:</p>

        <!-- Profile Picture Options -->
        <div class="profile-option">
            <label>
                <input type="radio" name="profile_picture" value="../profile/kucing.jpg" <?php if ($profile_picture == '../profile/kucing.jpg') echo 'checked'; ?>>
                <img src="../profile/kucing.jpg" alt="Kucing">
            </label>
            <label>
                <input type="radio" name="profile_picture" value="../profile/panda.jpg" <?php if ($profile_picture == '../profile/panda.jpg') echo 'checked'; ?>>
                <img src="../profile/panda.jpg" alt="Panda">
            </label>
            <label>
                <input type="radio" name="profile_picture" value="../profile/robot.jpg" <?php if ($profile_picture == '../profile/robot.jpg') echo 'checked'; ?>>
                <img src="../profile/robot.jpg" alt="Robot">
            </label>
            <label>
                <input type="radio" name="profile_picture" value="../profile/penguin.png" <?php if ($profile_picture == '../profile/penguin.png') echo 'checked'; ?>>
                <img src="../profile/penguin.png" alt="Penguin">
            </label>
            <label>
                <input type="radio" name="profile_picture" value="../profile/dog.jpg" <?php if ($profile_picture == '../profile/dog.jpg') echo 'checked'; ?>>
                <img src="../profile/dog.jpg" alt="Dog">
            </label>
            <label>
                <input type="radio" name="profile_picture" value="../profile/penguin2.png" <?php if ($profile_picture == '../profile/penguin2.png') echo 'checked'; ?>>
                <img src="../profile/penguin2.png" alt="Penguin 2">
            </label>
            <label>
                <input type="radio" name="profile_picture" value="../profile/monkey.png" <?php if ($profile_picture == '../profile/monkey.png') echo 'checked'; ?>>
                <img src="../profile/monkey.png" alt="Monkey">
            </label>
            <label>
                <input type="radio" name="profile_picture" value="../profile/panda2.jpg" <?php if ($profile_picture == '../profile/panda2.jpg') echo 'checked'; ?>>
                <img src="../profile/panda2.jpg" alt="Panda 2">
            </label>
            <label>
                <input type="radio" name="profile_picture" value="../profile/dinosaur.png" <?php if ($profile_picture == '../profile/dinosaur.png') echo 'checked'; ?>>
                <img src="../profile/dinosaur.png" alt="Dinosaur">
            </label>
        </div>

        <!-- Avatar Preview Section -->
        <div id="preview-section">
            <h3>Preview</h3>
            <img id="preview-image" src="<?php echo htmlspecialchars($profile_picture); ?>" alt="Preview">
            <p><?php echo htmlspecialchars($username); ?></p>
        </div>
    </div>

    <script>
        document.querySelectorAll('input[name="profile_picture"]').forEach(input => {
    input.addEventListener('change', function () {
        document.getElementById('preview-image').src = this.value;

        const xhr = new XMLHttpRequest();
        xhr.open('POST', '', true);
        xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        xhr.send(`profile_picture=${encodeURIComponent(this.value)}`);
        xhr.onload = function () {
            const response = JSON.parse(xhr.responseText);
            if (response.success) {
                alert(`Success! Your profile picture has been updated to "${this.value.split('/').pop().replace('.jpg', '').replace('.png', '')}"`);
            } else {
                alert('Oops! Something went wrong. Please try again.');
            }
        };
    });
});
    </script>
</body>
</html>
