<?php
session_start();
include('config.php');

$error = "";    

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Check if 'username' and 'password' fields are set in the POST request
    $username = isset($_POST['username']) ? $_POST['username'] : '';
    $password = isset($_POST['password']) ? $_POST['password'] : '';

    // Proceed only if both 'username' and 'password' are provided
    if ($username && $password) {
        $sql = "SELECT * FROM pelajar WHERE username = ? AND password = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('ss', $username, $password);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
            $_SESSION['username'] = $user['username']; // Store username in session

            // Redirect based on password prefix
            if (strpos($password, 'a') === 0) {
                header("Location: ../murid5/indexTahun5.php");
            } elseif (strpos($password, 'b') === 0) {
                header("Location: ../murid6/indexTahun6.php");
            } else {
                $error = "Kata laluan tidak sesuai dengan kriteria.";
            }
            exit();
        } else {
            $error = "Nama pengguna atau kata laluan salah!";
        }
    } else {
        $error = "Sila masukkan kedua-dua nama pengguna dan kata laluan.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Log Masuk Pelajar</title>
    <style>
        /* Styles for the login page */
        body {
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-image: url('../background/background.jpg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        .login-container {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 350px;
        }

        .error-message {
            color: red;
            font-size: 14px;
            margin-bottom: 20px;
            font-weight: bold;
        }

        .login-container img {
            width: 150px;
            height: auto;
            margin-bottom: 20px;
        }

        .login-container h2 {
            font-family: 'Arial', sans-serif;
            color: #333;
            margin-bottom: 20px;
        }

        .login-container input[type="text"],
        .login-container input[type="password"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            font-size: 16px;
            border: 2px solid #3498db;
            border-radius: 5px;
            box-sizing: border-box;
        }

        .password-container {
    position: relative;
}

.password-container input[type="password"],
.password-container input[type="text"] {
    width: 100%;
    padding: 10px 40px 10px 10px; /* Add space for the icon */
    font-size: 16px;
    border: 2px solid #3498db;
    border-radius: 5px;
    box-sizing: border-box;
    height: 40px; /* Set a fixed height for consistency */
}

.toggle-password {
    position: absolute;
    top: 30%;
    right: 10px;
    transform: translateY(-50%); /* This centers the icon vertically */
    cursor: pointer;
    font-size: 20px; /* Increased icon size */
    color: #3498db;
}

        .login-container button {
            font-family: 'Arial', sans-serif;
            font-size: 18px;
            padding: 10px 20px;
            color: #fff;
            background-color: #3498db;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-transform: uppercase;
            width: 100%;
            margin-bottom: 10px; /* Spacing below button */
        }

        .login-container button:hover {
            background-color: #2980b9;
        }

        .guru-link {
            margin-top: 15px;
            font-size: 14px;
            color: #333;
        }

        .guru-link a {
            color: #3498db;
            text-decoration: none;
            font-weight: bold;
        }

        .guru-link a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>

<div class="login-container">
    <!-- Logo -->
    <img src="../background/logo1.jpg" alt="Logo">
    <!-- Title -->
    <h2>Sila Masukkan Nama Pengguna dan Kata Laluan</h2>

    <!-- Error message display -->
    <?php if ($error != ""): ?>
        <div class="error-message">
            <?php echo htmlspecialchars($error); ?>
        </div>
    <?php endif; ?>

    <!-- Student login form -->
    <form action="LoginPelajar.php" method="POST">
        <input type="text" name="username" placeholder="Masukkan Nama Pengguna" required>
        <div class="password-container">
            <input type="password" id="password" name="password" placeholder="Masukkan Kata Laluan" required>
            <span class="toggle-password" onclick="togglePassword()">👁️</span>
        </div>
        <button type="submit">Log Masuk</button>
    </form>

    <!-- Text and hyperlink for teachers -->
    <div class="guru-link">
        Sekiranya anda guru, <a href="../guru/LoginGuru.php">click sini</a>.
    </div>
</div>

<script>
    function togglePassword() {
        const passwordField = document.getElementById('password');
        const toggleIcon = document.querySelector('.toggle-password');
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            toggleIcon.textContent = '🙈'; // Change icon to closed eye
        } else {
            passwordField.type = 'password';
            toggleIcon.textContent = '👁️'; // Change icon to open eye
        }
    }
</script>

</body>
</html>
