<?php
// Include the database configuration file
include '../intro/config.php';

// Handle form submission to update grades in the database
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Loop through each subject's grades and update the database
    foreach ($_POST['bahasa_melayu'] as $id => $grade) {
        $sql = "UPDATE pelajar SET bahasa_melayu = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $grade, $id);
        $stmt->execute();
    }
    foreach ($_POST['bahasa_inggeris'] as $id => $grade) {
        $sql = "UPDATE pelajar SET bahasa_inggeris = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $grade, $id);
        $stmt->execute();
    }
    foreach ($_POST['matematik_awal'] as $id => $grade) {
        $sql = "UPDATE pelajar SET matematik_awal = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $grade, $id);
        $stmt->execute();
    }
    foreach ($_POST['sains_awal'] as $id => $grade) {
        $sql = "UPDATE pelajar SET sains_awal = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $grade, $id);
        $stmt->execute();
    }
    foreach ($_POST['pendidikan_islam'] as $id => $grade) {
        $sql = "UPDATE pelajar SET pendidikan_islam = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("si", $grade, $id);
        $stmt->execute();
    }
    // Redirect to the same page to avoid resubmission on refresh
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan Pelajar 6 Tahun</title>
    <style>
      body {
            font-family: 'Helvetica Neue', Arial, sans-serif;
            background: linear-gradient(rgba(255, 255, 255, 0.8), rgba(255, 255, 255, 0.8)), 
                        url('img/bg.jpg') no-repeat center center fixed;
            background-size: cover; /* Ensure the image covers the entire background */
            margin: 0;
            padding: 80px 20px 20px; /* Added padding-top to make space for navbar */
            color: #333;
        }

        h2 {
            color: #333;
            text-align: center;
            margin-bottom: 20px;
            font-size: 1.8em;
            font-weight: 500;
        }

        /* Navbar Styles */
        .navbar {
            background-color: #94DEA5; /* Green background */
            padding: 10px 0;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            z-index: 1000;
            box-shadow: 0px 2px 5px rgba(0, 0, 0, 0.1);
        }

        .navbar .container {
            display: flex;
            justify-content: flex-end;
            align-items: center;
        }

        .navbar-logo {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
        }

        .logo {
            width: 50px;
            height: auto;
        }

        .navbar-button {
            font-size: 1.1em;
            font-weight: 600;
            color: #ffffff;
            text-decoration: none;
            padding: 10px 20px;
            border-radius: 8px;
            background-color: #4CAF50;
            transition: background-color 0.3s, transform 0.2s;
            margin: 0 10px;
        }

        .navbar-button:hover {
            background-color: #45a049;
            transform: translateY(-2px);
        }

        .navbar-button:active {
            background-color: #3e8e41;
            transform: translateY(0);
        }

        /* Dropdown Styles */
        .dropdown {
            position: relative;
            display: inline-block;
        }

        .dropdown:hover .dropdown-content {
            display: block;
        }

        .dropdown-content {
            display: none;
            position: absolute;
            background-color: #4CAF50;
            min-width: 160px;
            z-index: 1;
            box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.2);
            border-radius: 5px;
        }

        .dropdown-content a {
            color: white;
            padding: 12px 16px;
            text-decoration: none;
            display: block;
            font-size: 1em;
        }

        .dropdown-content a:hover {
            background-color: #45a049;
        }

        /* Button Container for Subjects */
        .button-container {
            display: flex;
            justify-content: center;
            gap: 20px; /* Space between buttons */
            margin-top: 20px;
        }

        .subject-button {
            background-color: #4CAF50; /* Green background */
            color: white;
            text-decoration: none;
            padding: 12px 20px;
            font-size: 1.1em;
            font-weight: 600;
            border-radius: 8px;
            transition: background-color 0.3s, transform 0.2s;
            display: inline-block;
        }

        .subject-button:hover {
            background-color: #45a049;
            transform: translateY(-2px);
        }

        .subject-button:active {
            background-color: #3e8e41;
            transform: translateY(0);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .button-container {
                flex-direction: column; /* Stack buttons vertically on smaller screens */
            }

            .subject-button {
                width: 100%; /* Make buttons full width */
                margin-bottom: 10px;
            }

            .navbar-logo img {
                width: 40px;
            }

            .navbar-button {
                font-size: 1em;
                padding: 12px 20px;
                width: 100%;
                text-align: center;
            }
        }

        table {
        width: 100%;
        border-collapse: collapse;
        margin: 20px 0;
        font-family: Arial, sans-serif;
    }

    table th, table td {
        padding: 12px;
        text-align: left;
        border: 1px solid #ddd;
    }

    table th {
        background-color: #4CAF50;
        color: white;
    }

    table tr {
    background-color: white;
    
    }

    table tr:hover {
        background-color: #bfb7a1;
    }

    /* Style for the print button */
    button {
        background-color: grey;
        color: white;
        padding: 10px 14px;
        border: none;
        cursor: pointer;
        font-size: 14px;
        border-radius: 4px;
        transition: background-color 0.3s ease;
        margin-right: 3px;
    }

    button:hover {
        background-color: #45a049;
    }

    @keyframes blink {
    10% {
        opacity: 0;
    }

    }

    /* Gaya untuk sijil */
.certificate {
    display: none;
    width: 100%;
    margin: 80px auto;
    padding: 30px;
    border: 8px solid #4CAF50; /* Hijau untuk sempadan */
    background-color: #FFF8DC; /* Warna kuning lembut */
    text-align: center;
    border-radius: 20px;
    box-shadow: 0px 0px 15px rgba(0, 0, 0, 0.2);
    min-height: 635px; /* Tinggikan sijil */
    background-image: url('img/bg1.jpg'); /* Menambah gambar latar belakang */
    background-size: cover; /* Pastikan gambar latar belakang memenuhi ruang */
    background-position: center; /* Pusatkan gambar latar belakang */
    background-repeat: no-repeat; /* Pastikan gambar tidak diulang */
}

.certificate img {
    position: relative;
    top: 0;
    left: 0;
    width: 200px;
    height: auto;
    margin-bottom: 20px;
}

.certificate h1 {
    font-size: 3.5em;
    font-weight: bold;
    color: #4CAF50; /* Hijau */
    font-family: 'Times New Roman', serif;
    margin-bottom: 10px;
}

.certificate h2 {
    font-size: 2.5em;
    font-weight: bold;
    color: #FF4500; /* Oren cerah */
    margin: 10px 0;
    font-family: 'Arial', sans-serif;
}

.certificate p {
    font-size: 1.5em;
    color: #333;
    margin: 15px 0;
    font-family: 'Georgia', serif;
}

.certificate .name {
    font-size: 2em;
    font-weight: bold;
    color: #000;
    margin: 20px 0;
}

.certificate .message {
    font-size: 1.2em;
    font-style: italic;
    color: #555;
    margin-top: 10px;
}

/* Untuk paparan print */
@media print {
    body * {
        visibility: hidden;
    }

    .certificate, .certificate * {
        visibility: visible;
    }

    .certificate {
        position: fixed; /* Tetap di tengah */
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%); /* Pusatkan sijil */
        margin: 0; /* Tiada margin tambahan */
        width: 100%; /* Pastikan sesuai untuk cetakan */
        box-shadow: none; /* Hilangkan bayang untuk cetakan */
        background-image: url('img/bg1.jpg'); /* Menambah gambar latar belakang untuk cetakan */
        background-size: cover; /* Pastikan gambar latar belakang memenuhi ruang */
        background-position: center; /* Pusatkan gambar latar belakang */
        background-repeat: no-repeat; /* Pastikan gambar tidak diulang */
    }
}

    </style>

     <script>
        function printCertificate(id) {
            // Show the certificate
            document.getElementById("certificate-" + id).style.display = "block";
            window.print();
            // Hide the certificate again after printing
            document.getElementById("certificate-" + id).style.display = "none";
        }
    </script>

</head>
<body>

    <!-- Navigation Bar -->
    <div class="navbar">
        <div class="container">
            <a href="dashboardGuru.php" class="navbar-logo">
                <img src="../background/logo1.jpg" alt="Logo" class="logo">
            </a>
            <a href="../intro/LoginPelajar.php" class="navbar-button">Login Page</a>
            <a href="dashboardGuru.php" class="navbar-button">Dashboard Pelajar</a>
            <div class="dropdown">
                <a href="#" class="navbar-button">Keputusan Pelajar</a>
                <div class="dropdown-content">
                    <a href="keputusanPelajar5.php">5 tahun</a>
                    <a href="keputusanPelajar6.php">6 tahun</a>
                </div>
            </div>
        </div>
    </div>

        <br><br>

        <h2>KEPUTUSAN PELAJAR 6 TAHUN</h2>

<div class="button-container">
    <div class="dropdown">
        <a href="#" class="subject-button">BAHASA MELAYU</a>
        <div class="dropdown-content">
            <a href="../keputusan6/KenaliKenderaan.php">Kenali Kenderaan: Jom Naik Kenderaan Seronok!</a>
            <a href="../keputusan6/Pekerjaan.php">Pekerjaan: Jom Jadi Apa?</a>
            <a href="../keputusan6/Perayaan.php">Perayaan: Seronoknya Raya!</a>
            <a href="../keputusan6/HariKebangsaan.php">Hari Kebangsaan: Jom Raikan Negara Kita!</a>
        </div>
    </div>

    <div class="dropdown">
        <a href="#" class="subject-button">BAHASA INGGERIS</a>
        <div class="dropdown-content">
        <a href="../keputusan6/AtTheZoo.php">At the Zoo:Let's Visit the Zoo!</a>
            <a href="../keputusan6/PublicPlaces.php">Public Places:Fun Places in the City!</a>
            <a href="../keputusan6/Occupations.php">Occupations:What Do You Want to Be?</a>
            <a href="../keputusan6/MyAwesomeWorld.php">My Awesome World!</a>
        </div>
    </div>

    <div class="dropdown">
        <a href="#" class="subject-button">MATEMATIK AWAL</a>
        <div class="dropdown-content">
        <a href="../keputusan6/PenambahandanPenolakan.php">Penambahan dan Penolakan</a>
            <a href="../keputusan6/MisteriJamdanMasa.php">Misteri Jam dan Masa!</a>
            <a href="../keputusan6/LompatNombor2.php">Kira-Kira Seronok: Lompat Nombor 2!</a>
            <a href="../keputusan6/MengenaliBentuk3D.php">Seronoknya Mengenali Bentuk 3D!</a>
        </div>
    </div>

    <div class="dropdown">
        <a href="#" class="subject-button">SAINS AWAL</a>
        <div class="dropdown-content">
        <a href="../keputusan6/KeajaibanCuaca.php">Keajaiban Cuaca!</a>
            <a href="../keputusan6/PengembaraanSeronok.php">Pengembaraan Seronok!</a>
            <a href="../keputusan6/HaiwanHebatdiDuniaLiar.php">Haiwan Hebat di Dunia Liar!</a>
            <a href="../keputusan6/KeseronokanMembeli-belah.php">Keseronokan Membeli-belah!</a>
        </div>
    </div>

    <div class="dropdown">
        <a href="#" class="subject-button">PENDIDIKAN ISLAM</a>
        <div class="dropdown-content">
            <a href="../keputusan6/kepercayaanSahih.php">Akidah:Kepercayaan Yang Sahih</a>
            <a href="../keputusan6/seronokBeribadah.php">Ibadah:Seronoknya Beribadah!</a>
            <a href="../keputusan6/kisahNabiNabi.php">Sirah:Kisah Nabi-Nabi yang Hebat!</a>
            <a href="../keputusan6/perangaiBaik.php">Akhlak:Perangai Baik, Hidup Bahagia!</a>
        </div>
    </div>
</div>

        <br><br><br><br><br><br>

    <h2>SIJIL PENHARGAAN UNTUK PELAJAR 6 TAHUN</h2><br>

        <p style="text-align: center; font-size: 1.2em; color: #FF4500; font-weight: bold; animation: blink 1s step-start infinite;">
        * Print sijil apabila pelajar selesai semua subjek *
        </p>

    <!-- Pelajar Data Table -->
    <form method="POST">
    <div id="table-container">
    <table>
    <tr>
        <th>ID</th>
        <th>Username</th>
        <th>Nama</th>
        <th>Cetakan</th>

    <?php
// Initialize a counter
$counter = 1;

// Fetch data from pelajar table where tahun = 5
$sql = "SELECT id, username, name FROM pelajar WHERE tahun = 6";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $counter++ . "</td>";
        echo "<td>" . $row["username"] . "</td>";
        echo "<td>" . $row["name"] . "</td>";
        echo "<td>";
        echo "<button type='button' onclick='printCertificate(" . $row['id'] . ")'>Print</button>";
        echo "</td>";
        echo "</tr>";

        // Bahagian sijil
        echo "<div id='certificate-" . $row['id'] . "' class='certificate'>";
        echo "<img src='img/logo1.jpg' alt='Logo PintarKids'>"; // Logo di atas kiri
        echo "<h1>Sijil Penghargaan</h1>"; // Tajuk utama
        echo "<h2>TANIAH</h2>"; // Teks besar kedua
        echo "<p><strong>PENGHARGAAN INI DIBERI KEPADA</strong></p>"; // Tajuk penghargaan
        echo "<p class='name'>" . $row["name"] . "</p>"; // Nama penerima
        echo "<p class='message'>Kerana telah menyelesaikan semua soalan di aplikasi PINTARKIDS</p>"; // Pesanan penghargaan
        echo "</div>";

        
         }
     } else {
         echo "<tr><td colspan='4'>Tiada data pelajar.</td></tr>";
     }
     ?>
 </table>
</div>
</form>

</body>
</html>
