<?php
// Sambungkan ke pangkalan data
include('../intro/config.php');

// Inisialisasi mesej untuk maklum balas pengguna
$message = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $newPassword = $_POST['new_password'];

    // Semak sama ada nama pengguna wujud dalam pangkalan data
    $sql = "SELECT * FROM guru WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Nama pengguna dijumpai, kemas kini kata laluan dalam pangkalan data
        $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

        $updateSql = "UPDATE guru SET password = ? WHERE username = ?";
        $updateStmt = $conn->prepare($updateSql);
        $updateStmt->bind_param('ss', $hashedPassword, $username);
        $updateStmt->execute();

        $message = "Kata laluan anda telah berjaya dikemas kini.";
    } else {
        $message = "Nama pengguna tidak dijumpai!";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kemas Kini Kata Laluan</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            background-image: url('../background/background.jpg');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        .forgot-container {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
            width: 350px;
        }

        .forgot-container h2 {
            font-family: 'Arial', sans-serif;
            color: #333;
            margin-bottom: 20px;
        }

        .forgot-container input[type="text"],
        .forgot-container input[type="password"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            font-size: 16px;
            border: 2px solid #3498db;
            border-radius: 5px;
            box-sizing: border-box;
        }

        .forgot-container button {
            font-family: 'Arial', sans-serif;
            font-size: 18px;
            padding: 10px 20px;
            color: #fff;
            background-color: #3498db;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-transform: uppercase;
            width: 100%;
        }

        .forgot-container button:hover {
            background-color: #2980b9;
        }

        .forgot-container .back-button {
            background-color: #95a5a6;
            margin-top: 10px;
            padding: 10px 20px;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-transform: uppercase;
            width: 100%;
        }

        .forgot-container .back-button:hover {
            background-color: #7f8c8d;
        }

        .message {
            font-family: 'Arial', sans-serif;
            color: #e74c3c;
            margin-top: 10px;
        }
    </style>
</head>
<body>

<div class="forgot-container">
    <h2>Kemas Kini Kata Laluan</h2>
    <form action="forgotPassword.php" method="POST">
        <input type="text" name="username" placeholder="Masukkan Nama Pengguna" required>
        <input type="password" name="new_password" placeholder="Masukkan Kata Laluan Baharu" required>
        <button type="submit">Kemas Kini Kata Laluan</button>
    </form>
    <button class="back-button" onclick="window.history.back();">Kembali</button>
    <?php if ($message != ""): ?>
        <div class="message"> <?php echo $message; ?> </div>
    <?php endif; ?>
</div>

</body>
</html>
