let currentQuestion = 0; // Pastikan ini bermula dari 0
let score = 0;

const questions = [
    {
        question: "Apakah wahyu pertama yang diturunkan kepada Nabi Muhammad SAW?",
        options: ["Bacalah dengan nama Tuhanmu", "Dirikanlah solat", "Berpuasalah"],
        answer: 1
    },
    {
        question: "Di manakah Nabi Muhammad SAW dilahirkan?",
        options: ["Madinah", "Makkah", "Yathrib"],
        answer: 2
    },
    {
        question: "Siapakah nama bapa Nabi Muhammad SAW?",
        options: ["Abdul Muttalib", "Abdullah", "Abu Talib"],
        answer: 2
    },
    {
        question: "Berapakah umur Nabi Muhammad SAW ketika menerima wahyu pertama?",
        options: ["25 tahun", "40 tahun", "50 tahun"],
        answer: 2
    },
    {
        question: "Apakah nama gua tempat Nabi Muhammad SAW menerima wahyu pertama?",
        options: ["Gua Hira", "Gua Thawr", "Gua Uhud"],
        answer: 1
    },
    {
        question: "Siapakah isteri pertama Nabi Muhammad SAW?",
        options: ["Khadijah", "Aisyah", "Safiyyah"],
        answer: 1
    },
    {
        question: "Berapa tahun Nabi Muhammad SAW dan Khadijah berkahwin?",
        options: ["10 tahun", "25 tahun", "40 tahun"],
        answer: 2
    },
    {
        question: "Apakah nama bapa saudara Nabi Muhammad SAW yang melindunginya?",
        options: ["Abu Talib", "Hamzah", "Abbas"],
        answer: 1
    },
    {
        question: "Apakah nama peristiwa penghijrahan Nabi Muhammad SAW ke Madinah?",
        options: ["Hijrah", "Fathu Makkah", "Ghazwah"],
        answer: 1
    },
    {
        question: "Berapa tahun Nabi Muhammad SAW berdakwah secara rahsia?",
        options: ["3 tahun", "10 tahun", "13 tahun"],
        answer: 1
    }
];

function checkAnswer(selectedOption) {
    const feedback = document.getElementById('feedback');
    if (selectedOption === questions[currentQuestion].answer) {
        score += 10;
        feedback.innerText = "Betul!";
        feedback.className = "feedback correct";
    } else {
        feedback.innerText = "Salah!";
        feedback.className = "feedback wrong";
    }
    feedback.style.display = 'block';

    // Kemaskini skor
    document.getElementById('score').innerText = score;

    setTimeout(() => {
        feedback.style.display = 'none';
        currentQuestion++; // Pindah ke soalan seterusnya
        nextQuestion();
    }, 1000);
}

function nextQuestion() {
    if (currentQuestion < questions.length) {
        // Kemaskini teks soalan dengan nombor soalan yang betul
        document.getElementById('question').innerText = `Soalan ${currentQuestion + 1}: ${questions[currentQuestion].question}`;
        
        // Kemaskini pilihan jawapan
        const options = document.querySelectorAll('.option-box');
        options.forEach((box, index) => {
            box.innerText = questions[currentQuestion].options[index];
        });
    } else {
        // Jika semua soalan telah dijawab, pergi ke halaman skor
        localStorage.setItem('score', score);
        window.location.href = 'score.php';
    }
}

function openSettings() {
    alert("Tetapan akan dibuka di sini.");
}

// Panggil nextQuestion untuk memaparkan soalan pertama
nextQuestion();