<?php
session_start();
require '../../intro/config.php'; // Sambungan ke pangkalan data

// Pastikan pengguna telah log masuk dan markah wujud dalam sesi
if (!isset($_SESSION['username']) || !isset($_SESSION['markah'])) {
    header('Location: game.php'); // Jika tiada sesi, kembali ke permainan
    exit();
}

$username = $_SESSION['username'];
$score = $_SESSION['markah'];

// Semak sama ada username wujud dalam jadual pelajar
$query = "SELECT username FROM pelajar WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) { // Jika username wujud dalam pelajar
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['submit_score'])) {
        // Simpan skor dalam jadual perayaan
        $insertQuery = "INSERT INTO perayaan (username, score) VALUES (?, ?)";
        $stmt = $conn->prepare($insertQuery);
        $stmt->bind_param("si", $username, $score);

        if ($stmt->execute()) {
            $_SESSION['markah'] = 0; // Reset markah selepas disimpan
            header('Location: ../../murid6/indexTahun6.php'); // Redirect ke halaman utama
            exit();
        } else {
            echo "Ralat menyimpan skor: " . $stmt->error;
        }
    }
} else {
    echo "Ralat: Username tidak dijumpai dalam pangkalan data pelajar.";
}

$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan Kuiz</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body class="result-body">
    <div class="result-container">
        <h1 class="result-title">Keputusan Kuiz</h1>
        <p class="result-score">Markah Anda: <strong><?php echo $score; ?></strong> / 100</p>
        <form action="score.php" method="get">
            <button type="submit" name="submit_score" class="result-button">Kembali Ke Halaman Utama</button>
        </form>
    </div>
</body>
</html>
