<?php
session_start();

// Reset the score if the reset=true parameter is passed
if (isset($_GET['reset']) && $_GET['reset'] == 'true') {
    $_SESSION['markah'] = 0; // Reset score
}

// Soalan dan jawapan
$soalan = [
    1 => [
        'soalan' => 'Apakah perayaan ini?',
        'gambar' => 'img/aidilfitri.jpg',
        'pilihan' => [
            'a' => 'Hari Raya Aidilfitri',
            'b' => 'Deepavali',
            'c' => 'Chinese New Year',
            'd' => 'Hari Gawai'
        ],
        'jawapan_benar' => 'a'
    ],
    2 => [
        'soalan' => 'Apakah perayaan ini?',
        'gambar' => 'img/deepavali.jpg',
        'pilihan' => [
            'a' => 'Hari Raya Aidilfitri',
            'b' => 'Deepavali',
            'c' => 'Chinese New Year',
            'd' => 'Hari Gawai'
        ],
        'jawapan_benar' => 'b'
    ],
    3 => [
        'soalan' => 'Apakah perayaan ini?',
        'gambar' => 'img/cny.jpg',
        'pilihan' => [
            'a' => 'Hari Raya Aidilfitri',
            'b' => 'Deepavali',
            'c' => 'Chinese New Year',
            'd' => 'Hari Gawai'
        ],
        'jawapan_benar' => 'c'
    ],
    4 => [
        'soalan' => 'Apakah perayaan ini?',
        'gambar' => 'img/hari_gawai.jpg',
        'pilihan' => [
            'a' => 'Hari Raya Aidilfitri',
            'b' => 'Deepavali',
            'c' => 'Chinese New Year',
            'd' => 'Hari Gawai'
        ],
        'jawapan_benar' => 'd'
    ],
    5 => [
        'soalan' => 'Apakah perayaan ini?',
        'gambar' => 'img/hari_natal.jpg',
        'pilihan' => [
            'a' => 'Hari Raya Aidilfitri',
            'b' => 'Deepavali',
            'c' => 'Chinese New Year',
            'd' => 'Hari Natal'
        ],
        'jawapan_benar' => 'd'
    ]
];

// Mendapatkan soalan yang sesuai berdasarkan parameter query 'q'
$soalan_id = isset($_GET['q']) ? (int)$_GET['q'] : 1;

// Memastikan soalan yang diminta wujud
if (!isset($soalan[$soalan_id])) {
    header("Location: score.php");
    exit();
}

// Menyediakan soalan dan pilihan jawapan
$soalan_text = htmlspecialchars($soalan[$soalan_id]['soalan']);
$gambar = htmlspecialchars($soalan[$soalan_id]['gambar']);
$pilihan = $soalan[$soalan_id]['pilihan'];
$jawapan_benar = trim($soalan[$soalan_id]['jawapan_benar']); // Trim whitespace

// Mendapatkan jawapan yang dipilih
$jawapan_pemilih = isset($_GET['jawapan']) ? trim($_GET['jawapan']) : '';

// Debugging: Semak nilai jawapan
// Uncomment untuk debug jika perlu
// var_dump($jawapan_pemilih, $jawapan_benar);

$feedback = '';
if ($jawapan_pemilih !== '') {
    if ($jawapan_pemilih === $jawapan_benar) {
        if (!isset($_SESSION['markah'])) {
            $_SESSION['markah'] = 0;
        }
        $_SESSION['markah'] += 10; // Tambah 10 mata untuk jawapan betul
        $feedback = 'Tahniah! Anda Betul.';
    } else {
        $feedback = 'Maaf, jawapan anda salah.';
    }
}

// Menentukan jika soalan berikutnya ada
$soalan_seterusnya = ($soalan_id < count($soalan)) ? ($soalan_id + 1) : 'selesai';
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Soalan <?php echo $soalan_id; ?></title>
    <link rel="stylesheet" href="styles.css">

    <style>
        /* Add animation for feedback */
        .feedback {
            animation: fadeOut 2s forwards; /* Fade out after 2 seconds */
            font-size: 1.5em;
            padding: 10px;
            margin: 20px 0;
        }

        /* Keyframes for fade out */
        @keyframes fadeOut {
            0% { opacity: 1; }
            99% { opacity: 1; }
            100% { opacity: 0; visibility: hidden; }
        }
    </style>
</head>
<body>
    <!-- Header section for score and settings -->
    <header class="header">
        <div class="score-display">
            <?php
                $score = isset($_SESSION['markah']) ? $_SESSION['markah'] : 0;
                echo htmlspecialchars("$score/100");
            ?>
        </div>
        <div class="settings-btn">
            <a href="setting.php">Tetapan</a>
        </div>
    </header>

    <div class="game-container">
        <h1><?php echo $soalan_text; ?></h1>
        <img src="<?php echo $gambar; ?>" alt="Perayaan" class="perayaan-img">

        <!-- Feedback for the selected answer -->
        <?php if ($jawapan_pemilih !== '') : ?>
            <div class="feedback">
                <p><?php echo htmlspecialchars($feedback); ?></p>
            </div>
        <?php endif; ?>

        <!-- Display choices -->
        <div class="choices">
            <?php foreach ($pilihan as $key => $value) : ?>
                <a href="game.php?q=<?php echo ($soalan_id + 1 <= count($soalan)) ? ($soalan_id + 1) : 'selesai'; 
                ?>&jawapan=<?php echo urlencode($key); ?>" class="choice-btn">
                    <?php echo htmlspecialchars($value); ?>
                </a>
            <?php endforeach; ?>
        </div>
    </div>

    <script>
        // Hide feedback after 2 seconds
        setTimeout(function() {
            const feedback = document.querySelector('.feedback');
            if (feedback) {
                feedback.style.display = 'none';
            }
        }, 2000);
    </script>
</body>
</html>
