let score = 0; // Store player's score
let currentLevel = 1; // Store the current level
let questionIndex = 0; // Track the current question
let username = ''; // Store the player's username

// Retrieve the username dynamically from the DOM
document.addEventListener("DOMContentLoaded", () => {
    const usernameElement = document.getElementById("username");
    const answerInput = document.getElementById("answer");

    // Check if username input exists
    if (usernameElement) {
        username = usernameElement.value; // Set the username
        console.log("Username retrieved:", username); // Debugging log
    } else {
        console.error("Error: Username element not found in the DOM.");
    }

    // Check if answer input exists and add input listener
    if (answerInput) {
        answerInput.addEventListener("input", updateSubmitButton);
    } else {
        console.error("Error: Answer input field not found in the DOM.");
    }

    // Display the first question on load
    displayQuestion();
});

// Questions for each level
const questionsByLevel = {
    1: [{ question: "5 + 3", answer: 8 }],
    2: [{ question: "10 + 2", answer: 12 }],
    3: [{ question: "15 - 6", answer: 9 }],
    4: [{ question: "20 - 8", answer: 12 }],
    5: [{ question: "25 + 10", answer: 35 }],
    6: [{ question: "40 - 15", answer: 25 }],
    7: [{ question: "25 + 15", answer: 40 }],
    8: [{ question: "47 - 17", answer: 30 }],
    9: [{ question: "50 - 25", answer: 25 }],
    10: [{ question: "50 - 15", answer: 35 }],
};

// Display the current question
const displayQuestion = () => {
    const questions = questionsByLevel[currentLevel];
    const currentQuestion = questions ? questions[questionIndex] : null;

    // Validate question existence
    if (!currentQuestion) {
        console.error(`Error: No question found for level ${currentLevel}, index ${questionIndex}`);
        return;
    }

    document.getElementById("question").innerText = currentQuestion.question;
    document.getElementById("answer").value = ""; // Clear answer input
    updateSubmitButton(); // Update the submit button state
};

// Update submit button state
const updateSubmitButton = () => {
    const answerInput = document.getElementById("answer").value;
    const submitButton = document.querySelector("button[onclick='checkAnswer()']");
    if (submitButton) {
        submitButton.disabled = answerInput.trim() === "";
    } else {
        console.error("Error: Submit button not found.");
    }
};

// Check the player's answer
const checkAnswer = () => {
    const answerInput = document.getElementById("answer");
    const correctMsg = document.getElementById("correct-msg");
    const wrongMsg = document.getElementById("wrong-msg");

    if (!answerInput || !correctMsg || !wrongMsg) {
        console.error("Error: One or more required elements are missing from the DOM.");
        return;
    }

    const userAnswer = parseInt(answerInput.value);
    const currentQuestion = questionsByLevel[currentLevel][questionIndex];

    if (userAnswer === currentQuestion.answer) {
        score += 10; // Increase score if correct
        correctMsg.style.display = "block"; // Show correct message
        setTimeout(() => (correctMsg.style.display = "none"), 2000);
    } else {
        wrongMsg.style.display = "block"; // Show wrong message
        setTimeout(() => (wrongMsg.style.display = "none"), 2000);
    }

    // Move to the next question
    questionIndex++;

    if (questionIndex >= questionsByLevel[currentLevel].length) {
        currentLevel++; // Move to the next level
        questionIndex = 0; // Reset question index
    }

    document.getElementById("score").innerText = score; // Update score display

    if (currentLevel > 10) {
        finishGame(); // End the game if all levels are completed
    } else {
        displayQuestion(); // Display next question
    }
};

// End the game and save the score
const finishGame = () => {
    // Check if the user has completed the game
    console.log("Game finished. Redirecting to score page...");

    // Save score to the database
    const formData = new FormData();
    formData.append('score', score);
    formData.append('username', username);

    fetch('score.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.text())
    .then(data => {
        console.log("Score saved:", data);
        // After saving the score, redirect to score.php
        window.location.href = "score.php";
    })
    .catch(error => {
        console.error("Error:", error);
        alert("There was an error saving your score. Please try again.");
    });
};
