<?php
session_start();
require '../../intro/config.php'; // Sambungan ke pangkalan data

// Semak jika pengguna telah log masuk dan skor wujud dalam sesi
if (!isset($_SESSION['username']) || !isset($_SESSION['score'])) {
    header('Location: game.php'); // Jika tiada sesi, kembali ke game
    exit();
}

$username = $_SESSION['username'];
$score = $_SESSION['score'];

// Pastikan username wujud dalam jadual pelajar
$query = "SELECT username FROM pelajar WHERE username = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $username);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) { // Jika username wujud dalam pelajar
    if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['submit_score'])) {
        // Simpan skor dalam jadual lompatnombor2
        $insertQuery = "INSERT INTO lompatnombor2 (username, score) VALUES (?, ?)";
        $stmt = $conn->prepare($insertQuery);
        $stmt->bind_param("si", $username, $score);

        if ($stmt->execute()) {
            $_SESSION['score'] = 0; // Reset skor selepas disimpan
            header('Location: ../../murid6/indexTahun6.php'); // Redirect ke halaman utama
            exit();
        } else {
            echo "Ralat menyimpan skor: " . $stmt->error;
        }
    }
} else {
    echo "Ralat: Username tidak dijumpai dalam pangkalan data pelajar.";
}

$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skor Akhir</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="game-container">
        <div class="background-image"></div>
        <div class="box-container">
            <h1>Skor Akhir Anda</h1>
            <p>Skor Anda: <strong><?php echo $score; ?></strong> / 100</p>
            <form action="score.php" method="get">
                <button type="submit" name="submit_score" class="submit-btn">Kembali ke Halaman Utama</button>
            </form>
        </div>
    </div>
</body>
</html>