<?php
session_start();

// Semak dan inisialisasi sesi
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0;
}

if (!isset($_SESSION['level']) || $_SESSION['level'] > 10) {
    $_SESSION['level'] = 1; // Reset ke tahap 1
    $_SESSION['score'] = 0; // Reset skor
    header("Location: score.php");
    exit();
}

$level = $_SESSION['level'];
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kira-Kira Seronok</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="game-container">
        <div class="background-image"></div>
        <div class="score">Skor: <?php echo $_SESSION['score']; ?> / 100</div>
        <div class="settings-btn" onclick="window.location.href='settings.php'">Tetapan</div>

        <div class="question">
            <?php
            if ($level <= 5) {
                $num1 = rand(1, 30);
                $num2 = rand(1, 30);
                $_SESSION['answer'] = $num1 + $num2;
                echo "<h2>Berapakah hasil tambah $num1 + $num2?</h2>";
            } elseif ($level <= 10) {
                $start = rand(2, 10) * 2;
                $_SESSION['answer'] = $start + 2;
                echo "<h2>Lengkapkan nombor: $start, <span class='placeholder'>__</span>, " . ($start + 4) . "</h2>";
            }
            ?>
            <form method="post" action="check_answer.php">
                <div class="input-container">
                    <input type="number" name="userAnswer" class="small-input" placeholder="Jawapan" required />
                    <button type="submit" class="submit-btn">Hantar Jawapan</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>