<?php
session_start();

// Jika skor belum ditetapkan, tetapkan kepada 0
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0;
}

// Tetapkan skor kepada 0 jika permainan dimulakan semula (q = 0)
if (isset($_GET['q']) && (int)$_GET['q'] === 0) {
    $_SESSION['score'] = 0;
}

// Senarai soalan
$questions = [
    ["Soalan: Bilakah Hari Kebangsaan Malaysia?", "31 Ogos", "16 September", "31 Ogos", "images/flag1.jpg"],
    ["Soalan: Apakah warna bendera Malaysia?", "Merah, Putih, Biru, Kuning", "Merah, Biru, Hijau", "Merah, Putih, Biru, Kuning", "images/flag2.jpg"],
    ["Soalan: Siapakah Perdana Menteri Malaysia sekarang?", "Anwar Ibrahim", "Muhyiddin Yassin", "Anwar Ibrahim", "images/pm.jpg"],
    ["Soalan: Dimanakah ibu negara Malaysia?", "Kuala Lumpur", "Penang", "Kuala Lumpur", "images/kuala_lumpur.jpg"],
    ["Soalan: Apakah nama rasmi bendera Malaysia?", "Jalur Gemilang", "Bendera Malaysia", "Jalur Gemilang", "images/jalur_gemilang.jpg"],
    ["Soalan: Apakah haiwan yang menjadi simbol negara Malaysia?", "Harimau Malaya", "Pelanduk", "Harimau Malaya", "images/harimau.jpg"],
    ["Soalan: Apakah nama lagu kebangsaan Malaysia?", "Negaraku", "Bersekutu Bertambah Mutu", "Negaraku", "images/negaraku.jpg"],
    ["Soalan: Apakah nama negeri terbesar di Malaysia?", "Sarawak", "Sabah", "Sarawak", "images/sarawak.jpg"],
    ["Soalan: Apakah warna bintang pada bendera Malaysia?", "Kuning", "Putih", "Kuning", "images/star.jpg"],
    ["Soalan: Berapakah jumlah jalur pada bendera Malaysia?", "14", "15", "14", "images/stripes.jpg"]
];

// Tentukan soalan semasa berdasarkan parameter q
$question_number = isset($_GET['q']) ? (int)$_GET['q'] : 0;

// Jika soalan lebih dari 9, redirect ke halaman keputusan
if ($question_number >= 10) {
    header("Location: result.php");
    exit();
}

$current_question = $questions[$question_number];

// Semak jika jawapan dihantar dan disemak
if (isset($_POST['answer'])) {
    // Semak jawapan
    if ($_POST['answer'] == 1 && $current_question[3] == $current_question[1]) {
        $_SESSION['score'] += 10;
    } elseif ($_POST['answer'] == 2 && $current_question[3] == $current_question[2]) {
        $_SESSION['score'] += 10;
    }

    // Pastikan markah tidak lebih dari 100
    if ($_SESSION['score'] > 100) {
        $_SESSION['score'] = 100;
    }

    // Alihkan ke soalan berikutnya
    header("Location: game.php?q=" . ($question_number + 1));
    exit();
}
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permainan Hari Kebangsaan Malaysia</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .score-display {
            position: absolute;
            top: 10px;
            left: 10px;
            font-size: 18px;
            font-weight: bold;
            background: #fff;
            padding: 5px 10px;
            border: 2px solid #000;
            border-radius: 5px;
        }

        .settings-button {
            position: absolute;
            top: 10px;
            right: 10px;
            background: #007BFF;
            color: white;
            padding: 5px 15px;
            text-decoration: none;
            font-size: 16px;
            font-weight: bold;
            border-radius: 5px;
        }

        .settings-button:hover {
            background: #0056b3;
        }

        .question-img {
            max-width: 100%;
            height: auto;
            margin: 20px 0;
        }

        .start-btn {
            display: inline-block;
            margin-top: 20px;
            background: #28a745;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            font-size: 16px;
            font-weight: bold;
            border-radius: 5px;
        }

        .start-btn:hover {
            background: #218838;
        }
    </style>
</head>
<body>
    <div class="score-display">
        <?php echo $_SESSION['score']; ?>/100
    </div>
    <a href="setting.php" class="settings-button">Tetapan</a>

        <br><br><br><br>

    <div class="container">
        <h2>Permainan Hari Kebangsaan Malaysia</h2>
        <p><?php echo $current_question[0]; ?></p>
        <img src="<?php echo $current_question[4]; ?>" alt="Gambar Soalan" class="question-img">

        <!-- Form untuk menjawab soalan -->
        <form method="POST" action="game.php?q=<?php echo $question_number; ?>">
            <button type="submit" name="answer" value="1"><?php echo $current_question[1]; ?></button>
            <button type="submit" name="answer" value="2"><?php echo $current_question[2]; ?></button>
        </form>

        
    </div>
</body>
</html>
