<?php
session_start();
include_once("../../intro/config.php");

// Ambil skor akhir dan nama pengguna
$final_score = $_SESSION['score'] ?? 0;
$username = $_SESSION['username'] ?? "Pengguna tidak dikenali";

// Simpan skor ke pangkalan data
if (isset($_SESSION['username'])) {
    $stmt = $conn->prepare("INSERT INTO pekerjaan (username, score) VALUES (?, ?)");
    $stmt->bind_param("si", $_SESSION['username'], $final_score);
    $stmt->execute();
    $stmt->close();
}

// Padam sesi permainan
unset($_SESSION['questions']);
unset($_SESSION['score']);
unset($_SESSION['current_question']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan Permainan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="results-container">
        <div class="result-box">
            <h1>Keputusan Permainan</h1>
            <p><strong>Nama Pengguna:</strong> <?= htmlspecialchars($username) ?></p>
            <p><strong>Skor Akhir Anda:</strong> <?= $final_score ?>/100</p>
            <a href="../../murid6/indexTahun6.php" class="btn">Kembali Ke Halaman Utama</a>
        </div>
    </div>
</body>
</html>
