<?php
session_start();
require '../../intro/config.php'; // Pastikan fail ini mempunyai sambungan ke database

// Semak jika sesi username wujud
if (!isset($_SESSION['username'])) {
    echo "<script>alert('Sila log masuk semula.'); window.location.href='../../login.php';</script>";
    exit;
}

$username = $_SESSION['username'];
$finalScore = isset($_GET['score']) ? (int) $_GET['score'] : 0; // Pastikan ada nilai default

// Masukkan skor ke dalam database
$sql = "INSERT INTO ibadah6 (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $username, $finalScore);
$stmt->execute();
$stmt->close();
$conn->close();
?>
<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skor Akhir</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <video autoplay muted loop id="background-video">
        <source src="backgrr1.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>
    <div class="score-page">
        <h1>Skor Anda</h1>
        <h2 id="final-score"><?= htmlspecialchars($finalScore); ?>/100</h2>
        <button onclick="redirectToHome()">Kembali Ke Halaman Utama</button>
    </div>

    <script>
        function redirectToHome() {
            window.location.href = "../../murid6/indexTahun6.php";
        }
    </script>
</body>
</html>
