<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <video autoplay muted loop id="background-video">
        <source src="backgrr1.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>
    <div class="game-header">
        <div class="score-display">Skor: <span id="score">0</span>/100</div>
        <button class="settings-button" onclick="openSettings()">Tetapan</button>
    </div>
    <div class="game-container">
    <h2 id="question"></h2>
    <div class="answer-buttons">
        <button onclick="checkAnswer(true)">Betul</button>
        <button onclick="checkAnswer(false)">Salah</button>
    </div>
    <div class="result" id="result"></div>
</div>
<script>
    const questions = [
        { question: "Puasa wajib dilakukan pada bulan Ramadan.", correct: true },
        { question: "Berbuka puasa dengan kurma adalah sunnah.", correct: true },
        { question: "Wuduk sah tanpa membasuh muka.", correct: false },
        { question: "Rukun wuduk ada enam.", correct: true },
        { question: "Niat solat mesti dibaca dalam hati.", correct: true },
        { question: "Berbohong membatalkan puasa.", correct: true },
        { question: "Sunat berwuduk bermula dengan membasuh kaki.", correct: false },
        { question: "Membasuh tangan hingga siku adalah salah satu rukun wuduk.", correct: true },
        { question: "Puasa bermula dari waktu terbenam matahari.", correct: false },
        { question: "Melakukan solat terawih adalah amalan sunnah Ramadan.", correct: true }
    ];
    let currentQuestion = 0;
    let score = 0;

    function loadQuestion() {
        if (currentQuestion < questions.length) {
            const questionElement = document.getElementById("question");
            const resultElement = document.getElementById("result");

            // Reset content
            resultElement.innerText = "";
            resultElement.classList.remove("correct", "wrong");

            // Load the next question
            questionElement.innerText = questions[currentQuestion].question;
        } else {
            // Redirect to score page after all questions
            window.location.href = "score.php?score=" + score;
        }
    }

    function checkAnswer(isCorrect) {
        const correct = questions[currentQuestion].correct;
        const resultElement = document.getElementById("result");

        if (isCorrect === correct) {
            score += 10;
            document.getElementById("score").innerText = score;
            resultElement.innerText = "BETUL! 👍";
            resultElement.classList.add("correct");
        } else {
            resultElement.innerText = "SALAH! ❌";
            resultElement.classList.add("wrong");
        }

        currentQuestion++;

        // Delay before loading the next question
        setTimeout(loadQuestion, 1500);
    }

    function openSettings() {
        alert("Tetapan permainan sedang dalam pembangunan.");
    }

    window.onload = loadQuestion;
</script>

</body>
</html>
