<?php
session_start();

// Tetapkan sesi jika tidak wujud
if (!isset($_SESSION['score']) || !isset($_SESSION['current_question'])) {
    $_SESSION['score'] = 0;
    $_SESSION['current_question'] = 1;
    $_SESSION['feedback'] = '';
    $_SESSION['answered'] = false;
}

$questions = [
    ["Apakah warna langit semasa hari cerah?", "Biru", "Kelabu", "Biru", "images/langit.jpg"],
    ["Apakah cuaca yang membuatkan anda basah jika berada di luar tanpa payung?", "Hujan", "Cerah", "Hujan", "images/hujan.jpg"],
    ["Apakah yang terjadi kepada awan semasa ribut petir?", "Gelap", "Putih", "Gelap", "images/kilat.jpg"],
    ["Apakah anda lihat semasa hari cerah selepas hujan?", "Pelangi", "Salji", "Pelangi", "images/pelangi.jpg"],
    ["Apakah pakaian yang sesuai semasa hari sejuk?", "Jaket", "T-Shirt", "Jaket", "images/baju.jpg"],
    ["Apakah yang dipegang orang semasa hujan?", "Payung", "Topi", "Payung", "images/payung.jpg"],
    ["Apakah yang menyebabkan pokok melambai semasa ribut?", "Angin", "Air", "Angin", "images/pokok.jpg"],
    ["Apakah warna salji?", "Putih", "Hitam", "Putih", "images/warna.jpg"],
    ["Apakah yang membuatkan hari menjadi gelap?", "Mendung", "Panas", "Mendung", "images/mendung.jpg"],
    ["Apakah cuaca yang panas sekali?", "Panas", "Hujan", "Panas", "images/siang.jpg"],
];

// Semak jika soalan terakhir telah dijawab
if ($_SESSION['current_question'] > count($questions)) {
    // Tetapkan semula permainan
    $_SESSION['score'] = 0;
    $_SESSION['current_question'] = 1;
    $_SESSION['feedback'] = '';
    $_SESSION['answered'] = false;
}

// Jika pengguna telah menjawab, periksa jawapan
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['answer'])) {
        $answer = $_POST['answer'];
        $correct_answer = $questions[$_SESSION['current_question'] - 1][3];

        if ($answer === $correct_answer) {
            $_SESSION['score'] += 10;
            $_SESSION['feedback'] = "BETUL!";
        } else {
            $_SESSION['feedback'] = "SALAH!";
        }

        $_SESSION['answered'] = true;
    }

    if (isset($_POST['next'])) {
        $_SESSION['current_question']++;
        $_SESSION['answered'] = false;

        // Jika soalan terakhir selesai, arahkan ke score.php
        if ($_SESSION['current_question'] > count($questions)) {
            header('Location: score.php');
            exit;
        }
    }
}

$current_question = $_SESSION['current_question'] - 1; // Pastikan indeks bermula dari 0
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <title>Permainan Cuaca</title>
</head>
<body>
<video id="background-video" autoplay loop muted>
    <source src="video/background.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>
<div class="header">
    <div class="score-display">Skor: <?php echo $_SESSION['score']; ?>/100</div>
    <button class="settings-button" onclick="window.location.href='setting.php'">Tetapan</button>
</div>
<div class="game-container">
    <h1>Soalan <?php echo $_SESSION['current_question']; ?>/<?php echo count($questions); ?></h1>
    <img src="<?php echo $questions[$current_question][4]; ?>" alt="Question Illustration" class="question-image">
    <p><?php echo $questions[$current_question][0]; ?></p>
    <form method="post">
        <?php if (!$_SESSION['answered']): ?>
            <button class="answer-button" type="submit" name="answer" value="<?php echo $questions[$current_question][1]; ?>">
                <?php echo $questions[$current_question][1]; ?>
            </button>
            <button class="answer-button" type="submit" name="answer" value="<?php echo $questions[$current_question][2]; ?>">
                <?php echo $questions[$current_question][2]; ?>
            </button>
        <?php else: ?>
            <p class="feedback <?php echo strtolower($_SESSION['feedback']); ?>">
                <?php echo $_SESSION['feedback']; ?>
            </p>
            <button class="next-button" type="submit" name="next">Soalan Seterusnya</button>
        <?php endif; ?>
    </form>
</div>
<script>
    const music = document.getElementById('background-music');
    music.volume = 0.2; // Laraskan kelantangan
</script>
</body>
</html>
