<?php
session_start();

// Ensure the session variables are initialized
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0;
}
if (!isset($_SESSION['current_question'])) {
    $_SESSION['current_question'] = 0;
}
if (!isset($_SESSION['feedback'])) {
    $_SESSION['feedback'] = '';
}

$questions = [
    ["Apa yang berlaku bila tolak pintu?", "images/image1.jpg"],
    ["Apa yang kamu buat bila buka laci meja?", "images/image2.jpg"],
    ["Apa jadi bila gerak kereta mainan ke depan?", "images/image3.jpg"],
    ["Kamu tolak atau tarik beg roda?", "images/image4.jpg"],
    ["Apa yang kamu buat bila bawa bola ke diri sendiri?", "images/image5.jpg"],
    ["Apa kamu guna untuk tutup peti sejuk?", "images/image6.jpg"],
    ["Apa jadi bila tarik rak buku lebih dekat?", "images/image7.jpg"],
    ["Bagaimana nak tolak kerusi roda ke depan?", "images/image8.jpg"],
    ["Apa kamu buat bila buka pintu almari?", "images/image9.jpg"],
    ["Apa kamu buat bila jalan dengan anjing?", "images/image10.jpg"]
];

$correct_answers = ["Tolak", "Tarik", "Tarik", "Tolak", "Tarik", "Tolak", "Tarik", "Tolak", "Tarik", "Tarik"];

// Redirect to the score page if all questions are answered
if ($_SESSION['current_question'] >= count($questions)) {
    header("Location: score.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $selected_answer = $_POST['answer'] ?? '';

    if (!empty($selected_answer) && $selected_answer === $correct_answers[$_SESSION['current_question']]) {
        $_SESSION['score'] += 10;
        $_SESSION['feedback'] = '<div class="feedback correct">BETUL!</div>';
    } else {
        $_SESSION['feedback'] = '<div class="feedback wrong">SALAH!.</div>';
    }

    // Move to the next question
    $_SESSION['current_question']++;
    if ($_SESSION['current_question'] >= count($questions)) {
        header("Location: score.php");
        exit;
    }
}

$current_question_index = $_SESSION['current_question'];
$current_question = $questions[$current_question_index];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game - Science</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>

<video autoplay loop muted id="background-video">
    <source src="background2.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

<div class="game-container">
    <div class="score">
        Skor: <?php echo $_SESSION['score']; ?>/100
    </div>

    <div class="question">
        <h2>Soalan <?php echo $current_question_index + 1; ?></h2>
        <p><?php echo $current_question[0]; ?></p>
        <?php if (!empty($current_question[1])): ?>
            <img src="<?php echo $current_question[1]; ?>" alt="Question Image" class="question-image">
        <?php endif; ?>
    </div>

    <form method="POST">
        <button type="submit" name="answer" value="Tolak" class="btn btn-answer">Tolak</button>
        <button type="submit" name="answer" value="Tarik" class="btn btn-answer">Tarik</button>
    </form>

    <?php echo $_SESSION['feedback']; ?>

    <a href="settings.php" class="settings-btn">Tetapan</a>
</div>
</body>
</html>
