<?php
session_start();
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0;
}

// Initialize an array to store correct answers
if (!isset($_SESSION['correct_answers'])) {
    $_SESSION['correct_answers'] = [];
}

$questions = [
    ['question' => 'What is the color of the sky?', 'image' => 'img/sky.jpg', 'options' => ['Blue', 'Green', 'Red', 'Yellow'], 'answer' => 'Blue'],
    ['question' => 'How many legs does a cat have?', 'image' => 'img/cat.jpg', 'options' => ['4', '3', '5', '6'], 'answer' => '4'],
    ['question' => 'What color is an apple?', 'image' => 'img/apple.jpg', 'options' => ['Red', 'Blue', 'Green', 'Yellow'], 'answer' => 'Red'],
    ['question' => 'What is this animal?', 'image' => 'img/dog.jpg', 'options' => ['Cat', 'Chicken', 'Dog', 'Cow'], 'answer' => 'Dog'],
    ['question' => 'How many suns are in the sky?', 'image' => 'img/sun.jpg', 'options' => ['1', '2', '3', '4'], 'answer' => '1'],
    ['question' => 'What color are tree leaves?', 'image' => 'img/tree.jpg', 'options' => ['Green', 'Red', 'Yellow', 'White'], 'answer' => 'Green'],
    ['question' => 'Which animal can fly?', 'image' => 'img/bird.jpg', 'options' => ['Elephant', 'Cat', 'Bird', 'Dog'], 'answer' => 'Bird'],
    ['question' => 'What is the shape of the moon?', 'image' => 'img/moon.jpg', 'options' => ['Square', 'Circle', 'Triangle', 'Triangle'], 'answer' => 'Circle'],
    ['question' => 'What color is a rose?', 'image' => 'img/rose.jpg', 'options' => ['Blue', 'Red', 'White', 'Green'], 'answer' => 'Red'],
    ['question' => 'What is a panda\'s favorite food?', 'image' => 'img/panda.jpg', 'options' => ['Bamboo', 'Meat', 'Fish', 'Bread'], 'answer' => 'Bamboo'],
];

$questionIndex = isset($_GET['q']) ? $_GET['q'] : 0;
if ($questionIndex >= count($questions)) {
    header('Location: result.php');
    exit();
}

$currentQuestion = $questions[$questionIndex];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userAnswer = $_POST['answer'];
    if ($userAnswer == $currentQuestion['answer']) {
        $_SESSION['score'] += 10; // Add 10 points for correct answer
        $_SESSION['correct_answers'][] = $currentQuestion['question']; // Store correct answers
    }
    header('Location: game.php?q=' . ($questionIndex + 1));
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game - My Awesome World</title>
    <link rel="stylesheet" href="style.css">
    <script>
        // Function to submit the form when an answer is selected
        function submitForm() {
            document.getElementById("quizForm").submit();
        }
    </script>
</head>
<body>
    <div class="container">
        <div class="score-display">Score: <?php echo $_SESSION['score']; ?> / 100</div>
        <h1>Question <?php echo $questionIndex + 1; ?></h1>
        <div class="question-container">
            <img src="<?php echo $currentQuestion['image']; ?>" alt="Image" class="question-image">
        </div>
        
        <div class="question-text">
            <p><?php echo $currentQuestion['question']; ?></p>
        </div>

        <form id="quizForm" method="POST" class="answers-container">
            <?php foreach ($currentQuestion['options'] as $option) : ?>
                <div class="answer-option">
                    <label>
                        <input type="radio" name="answer" value="<?php echo $option; ?>" required onclick="submitForm()">
                        <?php echo $option; ?>
                    </label>
                </div>
            <?php endforeach; ?>
        </form>
    </div>
</body>
</html>
