    <?php
    session_start();

    // Store questions and answers
    $questions = [
        [
            'question' => 'What is this animal?',
            'image' => 'images/lion.jpg',
            'answers' => ['Lion', 'Tiger', 'Cheetah', 'Leopard'],
            'correct' => 0
        ],
        [
            'question' => 'What is this animal?',
            'image' => 'images/elephant.jpg',
            'answers' => ['Elephant', 'Tiger', 'Rhino', 'Hippopotamus'],
            'correct' => 0
        ],
        [
            'question' => 'What is this animal?',
            'image' => 'images/giraffe.jpg',
            'answers' => ['Zebra', 'Giraffe', 'Deer', 'Camel'],
            'correct' => 1
        ],
        [
            'question' => 'What is this animal?',
            'image' => 'images/tiger.jpg',
            'answers' => ['Lion', 'Tiger', 'Cheetah', 'Jaguar'],
            'correct' => 1
        ],
        [
            'question' => 'What is this animal?',
            'image' => 'images/panda.jpg',
            'answers' => ['Cat', 'Panda', 'Bear', 'Koala'],
            'correct' => 1
        ],
        [
            'question' => 'What is this animal?',
            'image' => 'images/kangaroo.jpg',
            'answers' => ['Koala', 'Kangaroo', 'Wallaby', 'Opossum'],
            'correct' => 1
        ],
        [
            'question' => 'What is this animal?',
            'image' => 'images/hippopotamus.jpg',
            'answers' => ['Hippopotamus', 'Elephant', 'Rhino', 'Walrus'],
            'correct' => 0
        ],
        [
            'question' => 'What is this animal?',
            'image' => 'images/zebra.jpg',
            'answers' => ['Zebra', 'Horse', 'Donkey', 'Giraffe'],
            'correct' => 0
        ],
        [
            'question' => 'What is this animal?',
            'image' => 'images/koala.jpg',
            'answers' => ['Koala', 'Penguin', 'Sloth', 'Owl'],
            'correct' => 0
        ],
        [
            'question' => 'What is this animal?',
            'image' => 'images/gorilla.jpg',
            'answers' => ['Gorilla', 'Monkey', 'Chimpanzee', 'Orangutan'],
            'correct' => 0
        ]
    ];

    if (!isset($_SESSION['score'])) {
        $_SESSION['score'] = 0;
    }
    if (!isset($_SESSION['question_index'])) {
        $_SESSION['question_index'] = 0;
    }
    
    // Validate current question index
    $question_index = $_SESSION['question_index'];
    if (!isset($questions[$question_index])) {
        header("Location: result.php");
        exit();
    }
    
   // Process answer selection
if (isset($_GET['answer'])) {
    $selected = (int)$_GET['answer'];

    // Tambah skor jika jawapan betul
    if ($selected === $questions[$question_index]['correct']) {
        $_SESSION['score'] += 10; // Tambah 10 mata jika betul
    }

    // Pindah ke soalan seterusnya
    $_SESSION['question_index']++;

    // Jika semua soalan telah dijawab, teruskan ke halaman keputusan
    if ($_SESSION['question_index'] >= count($questions)) {
        header("Location: result.php");
        exit();
    }

    // Refresh untuk memuatkan soalan seterusnya
    header("Location: game.php");
    exit();
}

    
    ?>

    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Zoo Animal Quiz</title>
        <link rel="stylesheet" href="style.css">
    </head>
    <body>
        
        <!-- Score Display -->
        <div class="score-display">
            <?php echo $_SESSION['score'] . "/100"; ?>
        </div>

        <!-- Settings Button -->
        <a href="settings.php" class="settings-button">Settings</a>


        <div class="container">
            <h2>Question <?php echo $question_index + 1; ?> of <?php echo count($questions); ?></h2>
            <p><?php echo htmlspecialchars($questions[$question_index]['question']); ?></p>
            <img src="<?php echo htmlspecialchars($questions[$question_index]['image']); ?>" alt="Animal Image" class="animal-image">

            <div class="choices">
                <?php
                foreach ($questions[$question_index]['answers'] as $index => $answer) {
                    echo "<a href='game.php?answer=" . htmlspecialchars($index) . "' class='choice-button'>" . htmlspecialchars($answer) . "</a>";
                }
                ?>
            </div>
        </div>
    </body>
    </html>
