<?php
// Starting the session to maintain the session data
session_start();

// Get the referer (previous page URL) for the back button
$referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'index.php'; // Default to index.php if no referer is found
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tetapan Permainan</title>
    <link rel="stylesheet" href="style.css">
    <style>
        /* Basic style to center content */
        body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background-color: #f4f4f9;
            font-family: Arial, sans-serif;
            position: relative;
        }

        /* Style for the back button */
        .back-button {
            position: absolute;
            top: 20px;
            left: 20px;
            padding: 10px 15px;
            font-size: 16px;
            color: white;
            background-color: #ff6347;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
        }

        .back-button:hover {
            background-color: #e5533b;
        }

        .settings-container {
            text-align: center;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .settings-container h1 {
            margin-bottom: 30px;
        }

        .settings-button {
            display: inline-block;
            margin: 10px 0;
            padding: 10px 20px;
            font-size: 16px;
            color: white;
            background-color: #4CAF50;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
        }

        .settings-button:hover {
            background-color: #45a049;
        }

        .settings-button-back {
            background-color: #2196F3;
        }

        .settings-button-back:hover {
            background-color: #0b7dda;
        }
    </style>
</head>
<body>

    <!-- Back button at the top-left corner -->
    <a href="<?php echo $referer; ?>" class="back-button">Kembali</a>

    <div class="settings-container">
        <h1>Tetapan Permainan</h1>

        <!-- Restart button -->
        <a href="index.php" class="settings-button">Mula Semula</a><br>

        <!-- Back to home button -->
        <a href="../../murid6/indexTahun6.php" class="settings-button settings-button-back">Kembali ke halaman utama</a>
    </div>
</body>
</html>
