<?php
session_start();
if (!isset($_SESSION['score'])) $_SESSION['score'] = 0;
if (!isset($_SESSION['level'])) $_SESSION['level'] = 1;

$questions = [
    1 => ["Apakah Rukun Islam yang pertama?", ["Syahadah", "Solat", "Puasa", "Haji"], "Syahadah"],
    2 => ["Berapa kali solat wajib dilakukan setiap hari?", ["5 kali", "3 kali", "2 kali", "6 kali"], "5 kali"],
    3 => ["Bulan apa kita berpuasa?", ["Ramadhan", "Syawal", "Rejab", "Zulhijah"], "Ramadhan"],
    4 => ["Zakat diberikan kepada orang yang?", ["Miskin", "Kaya", "Rajin", "Berjaya"], "Miskin"],
    5 => ["Ibadah haji dilakukan di mana?", ["Mekah", "Madinah", "Mesir", "Jordan"], "Mekah"],
    6 => ["Puasa bermaksud menahan diri daripada apa?", ["Makan dan minum", "Tidur", "Bermain", "Belajar"], "Makan dan minum"],
    7 => ["Apakah maksud syahadah?", ["Mengaku Allah adalah Tuhan dan Nabi Muhammad Rasul-Nya", "Rajin belajar", "Berbuat baik", "Rajin berdoa"], "Mengaku Allah adalah Tuhan dan Nabi Muhammad Rasul-Nya"],
    8 => ["Rukun Islam ada berapa?", ["5", "3", "7", "10"], "5"],
    9 => ["Zakat termasuk rukun Islam ke berapa?", ["3", "4", "5", "1"], "4"],
    10 => ["Bulan Haji ialah bulan?", ["Zulhijah", "Ramadhan", "Syawal", "Rejab"], "Zulhijah"],
];

$currentLevel = $_SESSION['level'];

if ($currentLevel > count($questions)) {
    header('Location: score.php');
    exit;
}

$currentQuestion = $questions[$currentLevel];
$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $selectedAnswer = $_POST['answer'];
    if ($selectedAnswer === $currentQuestion[2]) {
        $_SESSION['score'] += 10;
        $message = "BETUL";
    } else {
        $message = "SALAH";
    }
    $_SESSION['level']++;
    header('Refresh: 1; URL=game.php'); // Refresh page after 1 second
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permainan Akidah</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<video autoplay muted loop class="background-video">
    <source src="backgrr.mp4" type="video/mp4">
    Your browser does not support the video tag.
</video>

<div class="header">
    <div class="score">Skor: <?= $_SESSION['score']; ?>/100</div>
    <button class="settings-button" onclick="alert('Fungsi tetapan akan datang!')">Tetapan</button>
</div>

<div class="game-container">
    <div class="game-content">
        <h2>Soalan Level <?= $currentLevel; ?></h2>
        <p><?= $currentQuestion[0]; ?></p>
        <form method="POST">
            <?php foreach ($currentQuestion[1] as $option): ?>
                <button type="submit" name="answer" value="<?= $option; ?>" class="answer-button"><?= $option; ?></button>
            <?php endforeach; ?>
        </form>
        <?php if (!empty($message)): ?>
            <p class="result-message"><?= $message; ?></p>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
