<?php
session_start();
require '../../intro/config.php'; // Pastikan fail ini mempunyai sambungan ke database

// Semak jika sesi username wujud
if (!isset($_SESSION['username'])) {
    echo "<script>alert('Sila log masuk semula.'); window.location.href='../../login.php';</script>";
    exit;
}

$username = $_SESSION['username'];
$finalScore = isset($_GET['score']) ? (int) $_GET['score'] : 0; // Pastikan ada nilai default

// Masukkan skor ke dalam database
$sql = "INSERT INTO akhlak6 (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("si", $username, $finalScore);
$stmt->execute();
$stmt->close();
$conn->close();
?>
<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <!-- Background Video -->
    <video id="backgroundVideo" autoplay muted loop>
        <source src="b1.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>

    <!-- Container untuk keputusan -->
    <div class="score-container">
        <h1 class="score-header">Keputusan Anda</h1>
        <p id="finalScore">Skor: <?= htmlspecialchars($finalScore); ?>/100</p>
        <button id="restartButton" onclick="redirectToHome()">Kembali Ke Halaman Utama</button>
    </div>

    <script>
        function redirectToHome() {
            window.location.href = '../../murid6/indexTahun6.php';
        }
    </script>
</body>
</html>
