<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Soalan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>

<video autoplay muted loop id="background-video">
            <source src="backg.mp4" type="video/mp4">
        </video>

    <div class="game-container">
        <div class="top-bar">
            <div class="score">Skor: <span id="score">0</span>/100</div>
            <button id="settings-button">Tetapan</button>
        </div>
        <div id="question-container">
            <p id="question">Soalan akan dimuatkan di sini...</p>
            <div class="options" id="options-container">
                <!-- Pilihan akan dimuatkan secara dinamik -->
            </div>
            <div id="result" class="result"></div>
            <div id="image-container" class="image-container"></div>
        </div>
    </div>
    <script>
        let score = 0;
        let currentQuestionIndex = 0;
        let selectedAnswers = [];

        const questions = [
            {
                question: "Kenderaan yang bergerak di darat.",
                options: ["Bas", "Kapal Terbang", "Kereta", "Bot"],
                correct: ["Bas", "Kereta"],
                images: ["bas.jpg", "kereta.jpg"]
            },
            {
                question: "Kenderaan yang boleh terbang.",
                options: ["Helikopter", "Bot", "Kapal Terbang", "Bas"],
                correct: ["Helikopter", "Kapal Terbang"],
                images: ["helikopter.jpg", "kapalterbang.jpg"]
            },
            {
                question: "Kenderaan yang bergerak di air.",
                options: ["Kapal", "Bot", "Kereta", "Lori"],
                correct: ["Kapal", "Bot"],
                images: ["kapal.jpg", "bot.jpg"]
            },
            {
                question: "Kenderaan tanpa enjin.",
                options: ["Basikal", "Belon Udara Panas", "Kapal", "Kapal Terbang"],
                correct: ["Basikal", "Belon Udara Panas"],
                images: ["basikal.jpg", "belonpanas.jpg"]
            },
            {
                question: "Kenderaan yang digunakan untuk membawa barang.",
                options: ["Lori", "Kereta", "Bot", "Kapal"],
                correct: ["Lori", "Kapal"],
                images: ["lori.jpg", "kapal.jpg"]
            },
            {
                question: "Kenderaan yang berada di udara.",
                options: ["Bas", "Kereta", "Kapal Terbang", "Helikopter"],
                correct: ["Kapal Terbang", "Helikopter"],
                images: ["kapalterbang.jpg", "helikopter.jpg"]
            },
            {
                question: "Kenderaan yang kecil.",
                options: ["Motosikal", "Basikal", "Lori", "Bot"],
                correct: ["Motosikal", "Basikal"],
                images: ["moto.jpg", "basikal.jpg"]
            },
            {
                question: "Kenderaan untuk membawa penumpang di udara.",
                options: ["Helikopter", "Kapal Terbang", "Bas", "Kapal"],
                correct: ["Helikopter", "Kapal Terbang"],
                images: ["helikopter.jpg", "kapalterbang.jpg"]
            },
            {
                question: "Kenderaan yang digunakan untuk membawa penumpang di laut.",
                options: ["Bot", "Kapal", "Basikal", "Lori"],
                correct: ["Bot", "Kapal"],
                images: ["bot.jpg", "kapal.jpg"]
            },
            {
                question: "Kenderaan darat yang memerlukan tenaga manusia.",
                options: ["Basikal", "Kereta", "Lori", "Kapal"],
                correct: ["Basikal"],
                images: ["basikal.jpg"]
            }
        ];

        function loadQuestion() {
            if (currentQuestionIndex < questions.length) {
                const questionData = questions[currentQuestionIndex];
                document.getElementById('question').textContent = `Soalan ${currentQuestionIndex + 1}: ${questionData.question}`;

                const optionsContainer = document.getElementById('options-container');
                optionsContainer.innerHTML = '';
                document.getElementById('result').textContent = '';
                document.getElementById('image-container').innerHTML = '';

                questionData.options.forEach(option => {
                    const optionElement = document.createElement('div');
                    optionElement.classList.add('option');
                    optionElement.textContent = option;
                    optionElement.onclick = () => selectAnswer(option, optionElement);
                    optionsContainer.appendChild(optionElement);
                });
            } else {
                window.location.href = `score.php?score=${score}`;
            }
        }

        function selectAnswer(choice, element) {
            if (!selectedAnswers.includes(choice)) {
                selectedAnswers.push(choice);
                element.classList.add('selected');
            }

            if (selectedAnswers.length === questions[currentQuestionIndex].correct.length) {
                checkAnswers();
            }
        }

        function checkAnswers() {
            const questionData = questions[currentQuestionIndex];
            let correctCount = 0;

            selectedAnswers.forEach(answer => {
                if (questionData.correct.includes(answer)) {
                    correctCount++;
                }
            });

            if (correctCount === questionData.correct.length) {
                score += 10;
                document.getElementById('score').textContent = score;
                document.getElementById('result').textContent = 'BETUL!';
                document.getElementById('result').className = 'result correct';

                const imageContainer = document.getElementById('image-container');
                questionData.images.forEach(imageSrc => {
                    const img = document.createElement('img');
                    img.src = imageSrc;
                    img.alt = 'Jawapan Betul';
                    img.className = 'answer-image';
                    imageContainer.appendChild(img);
                });
            } else {
                document.getElementById('result').textContent = 'SALAH!';
                document.getElementById('result').className = 'result incorrect';
            }

            setTimeout(() => {
                selectedAnswers = [];
                currentQuestionIndex++;
                loadQuestion();
            }, 3000);
        }

        window.onload = loadQuestion;
    </script>
</body>
</html>