<?php
$levels = [
    ["image" => "img/meja.png", "word" => "meja", "missing" => "e"],
    ["image" => "img/kerusi.png", "word" => "kerusi", "missing" => "e"],
    ["image" => "img/almari.png", "word" => "almari", "missing" => "a"],
    ["image" => "img/katil.png", "word" => "katil", "missing" => "a"],
    ["image" => "img/sofa.png", "word" => "sofa", "missing" => "o"],
    ["image" => "img/cermin.png", "word" => "cermin", "missing" => "e"],
    ["image" => "img/meja_bulat.png", "word" => "meja bulat", "missing" => "e"],
    ["image" => "img/rak.png", "word" => "rak", "missing" => "a"],
    ["image" => "img/langsir.png", "word" => "langsir", "missing" => "a"],
    ["image" => "img/tilam.png", "word" => "tilam", "missing" => "i"],
];

$level = isset($_GET['level']) ? (int)$_GET['level'] : 0;
$message = isset($_GET['message']) ? $_GET['message'] : '';
$score = isset($_GET['score']) ? (int)$_GET['score'] : 0;

if ($level >= count($levels)) {
    header("Location: score.php?score=$score");
    exit;
}

$current = $levels[$level];

// Check if the game has started
$hasStarted = isset($_GET['start']);

?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permainan Mengeja</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <!-- Video Latar Belakang -->
    <video autoplay muted loop id="background-video">
        <source src="img/bg.mp4" type="video/mp4">
        Video tidak disokong oleh pelayar anda.
    </video>

    <!-- Audio Latar Belakang -->
    <audio autoplay loop>
        <source src="audio/bg.mp3" type="audio/mpeg">
        Audio tidak disokong oleh pelayar anda.
    </audio>

    <?php if (!$hasStarted): ?>
        <!-- Halaman Mula -->
        <div class="start-page">
            <h1>Selamat Datang ke Permainan Mengeja!</h1>
            <button class="start-button" onclick="window.location.href='?start=true&level=0&score=0'">Mula</button>
        </div>
    <?php else: ?>
        <div class="score">Skor: <?= $score ?>/100</div>
        <button class="settings-button" onclick="window.location.href='settings.php'">Tetapan</button>

        <div class="game-container">
            <h2> SILA ISI TEMPAT KOSONG </h2>

            <!-- Paparan mesej -->
            <?php if ($message === 'correct'): ?>
    <div class="message1 animate-message">Tahniah, Anda Betul!</div>
    <audio autoplay>
        <source src="audio/correct.mp3" type="audio/mpeg">
        Audio tidak disokong oleh pelayar anda.
    </audio>

     <!-- Correct Image -->
     <img id="correct-image" src="img/corectboy1.png" class="correct-image">
<?php elseif ($message === 'incorrect'): ?>
    <div class="message2 animate-message">Anda Salah,</div>
    <audio autoplay>
        <source src="audio/wrong.mp3" type="audio/mpeg">
        Audio tidak disokong oleh pelayar anda.
    </audio>

    <!-- Incorrect Image -->
    <img id="incorrect-image" src="img/wrong1.png" class="incorrect-image">
<?php endif; ?>



            <img src="<?= $current['image'] ?>" alt="Gambar <?= $current['word'] ?>">
            <div class="word-container">
                <?php
                $word = str_split($current['word']);
                foreach ($word as $letter) {
                    if ($letter === $current['missing']) {
                        echo "<span class='missing-letter'>_</span>";
                    } else {
                        echo "<span class='letter'>$letter</span>";
                    }
                }
                ?>
            </div>
            <div class="choices">
                <?php
                $choices = ['a', 'e', 'i', 'o', 'u'];
                shuffle($choices);
                foreach ($choices as $choice) {
                    $isCorrect = $choice === $current['missing'] ? 'correct' : 'incorrect';
                    $nextLevel = $level + 1; // Always move to the next level
                    $newScore = $choice === $current['missing'] ? $score + 10 : $score; // Update score only if correct
                    echo "<button class='choice' onclick=\"window.location.href='?start=true&level=$nextLevel&message=$isCorrect&score=$newScore'\">$choice</button>";
                }
                
                ?>
            </div>
        </div>
    <?php endif; ?>

    <script>
window.onload = function() {
    <?php if ($message === 'correct'): ?>
        setTimeout(function() {
            var correctImage = document.getElementById('correct-image');
            var message = document.querySelector('.message1');
            correctImage.style.bottom = '0'; // Slide the image up to the viewport
            correctImage.style.opacity = '1'; // Fade in the image
            message.style.opacity = '1'; // Show the message

            // Hide the message and image after 2 seconds
            setTimeout(function() {
                message.style.opacity = '0'; // Fade out the message
                correctImage.style.opacity = '0'; // Fade out the image
                correctImage.style.bottom = '-50%'; // Move the image off the screen
            }, 2000); // 2 seconds delay
        }, 500); // Delay to allow other elements to load first
    <?php elseif ($message === 'incorrect'): ?>
        setTimeout(function() {
            var incorrectImage = document.getElementById('incorrect-image');
            var message = document.querySelector('.message2');
            incorrectImage.style.bottom = '0'; // Slide the image up to 50% of the screen
            incorrectImage.style.opacity = '1'; // Fade in the image
            message.style.opacity = '1'; // Show the message

            // Hide the message and image after 2 seconds
            setTimeout(function() {
                message.style.opacity = '0'; // Fade out the message
                incorrectImage.style.opacity = '0'; // Fade out the image
                incorrectImage.style.bottom = '-50%'; // Move the image off the screen
            }, 2000); // 2 seconds delay
        }, 500); // Delay to allow other elements to load first
    <?php endif; ?>
};
</script>



</body>
</html>
