<?php
session_start();
require_once '../../intro/config.php'; // Sambung ke pangkalan data

// Dapatkan skor dari sesi
$score = isset($_SESSION['score']) ? $_SESSION['score'] : 0;
$totalQuestions = 10;
$maxScore = 100;

// Ambil nama pengguna dari sesi
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'guest'; // Tetapkan nama pengguna lalai jika tiada

// Masukkan data ke dalam pangkalan data jika username wujud
if ($username != '') {
    $query = "INSERT INTO kindergarten (username, score) VALUES (?, ?)";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("si", $username, $score);
    $stmt->execute();
}

// Tutup sambungan pangkalan data
$conn->close(); 
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan - My Awesome World</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Keputusan Permainan</h1>
        <p>Skor anda: <?php echo $score; ?> / <?php echo $maxScore; ?></p>
        
        <div class="stars-and-button">
            <div class="stars">
                <?php
                $stars = floor(($score / $maxScore) * 10);
                for ($i = 0; $i < $stars; $i++) {
                    echo "★";
                }
                ?>
            </div>
            <a href="../../murid5/indexTahun5.php" class="back-button">Kembali ke Halaman Utama</a>
        </div>
    </div>
</body>
</html>

<?php
session_unset();
session_destroy();
?>
