<?php
session_start();
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0;
}

// Initialize an array to store correct answers
if (!isset($_SESSION['correct_answers'])) {
    $_SESSION['correct_answers'] = [];
}

$questions = [
    ['question' => 'What do we do with crayons in kindergarten?', 'image' => 'img/crayons.jpg', 'options' => ['Draw', 'Cook', 'Sleep', 'Clean'], 'answer' => 'Draw'],
    ['question' => 'What is the color of the kindergarten bus?', 'image' => 'img/bus.jpg', 'options' => ['Yellow', 'Red', 'Green', 'Blue'], 'answer' => 'Yellow'],
    ['question' => 'Which of these is a favorite snack in kindergarten?', 'image' => 'img/sandwich.jpg', 'options' => ['Sandwich', 'Cake', 'Pizza', 'Chocolates'], 'answer' => 'Sandwich'],
    ['question' => 'Where do we play with toys?', 'image' => 'img/toys.jpg', 'options' => ['Kitchen', 'Bathroom', 'Playground', 'Bedroom'], 'answer' => 'Playground'],
    ['question' => 'What animal says "moo"?', 'image' => 'img/cow.jpg', 'options' => ['Dog', 'Cat', 'Cow', 'Duck'], 'answer' => 'Cow'],
    ['question' => 'Which of these do we wear to keep warm in winter?', 'image' => 'img/jacket.jpg', 'options' => ['Hat', 'Shirt', 'Jacket', 'Glove'], 'answer' => 'Jacket'],
    ['question' => 'What color is the sky?', 'image' => 'img/sky.jpg', 'options' => ['Blue', 'Green', 'Red', 'Yellow'], 'answer' => 'Blue'],
    ['question' => 'What do you use to write on paper?', 'image' => 'img/pencil.jpg', 'options' => ['Pen', 'Pencil', 'Marker', 'Eraser'], 'answer' => 'Pencil'],
    ['question' => 'What sound does a cat make?', 'image' => 'img/cat.jpg', 'options' => ['Moo', 'Meow', 'Woof', 'Quack'], 'answer' => 'Meow'],
    ['question' => 'Which of these is a fruit?', 'image' => 'img/apple.jpg', 'options' => ['Carrot', 'Apple', 'Potato', 'Onion'], 'answer' => 'Apple'],
];

$questionIndex = isset($_GET['q']) ? $_GET['q'] : 0;
if ($questionIndex >= count($questions)) {
    // Redirect to results page when all questions are answered
    header('Location: result.php');
    exit();
}

$currentQuestion = $questions[$questionIndex];

$message = '';  // Initialize the message variable
$messageColor = '';  // Initialize the color for the message

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userAnswer = $_POST['answer'];
    if ($userAnswer == $currentQuestion['answer']) {
        $_SESSION['score'] += 10; // Add 10 for correct answer
        $_SESSION['correct_answers'][] = $currentQuestion['question']; // Store correct answers
        $message = 'Tahniah! Jawapan kamu betul!';  // Correct answer message
        $messageColor = 'green';  // Set message color to green
    } else {
        $message = 'Cuba lagi! Kamu pasti boleh!';  // Incorrect answer message
        $messageColor = 'red';  // Set message color to red
    }
    header('Location: game.php?q=' . ($questionIndex + 1));
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game - My Awesome Kindergarten</title>
    <link rel="stylesheet" href="style.css">
    <script>
        function submitForm() {
            document.getElementById("quizForm").submit();
        }
    </script>
    <style>
        .score {
            position: absolute;
            top: 10px;
            left: 10px;
            font-size: 18px;
            font-weight: bold;
            color: #000;
        }
        .settings-btn-container {
            position: absolute;
            top: 10px;
            right: 10px;
        }
        .settings-btn {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px 15px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 16px;
            cursor: pointer;
        }
        .message {
            font-size: 20px;
            font-weight: bold;
            text-align: center;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    
<div class="score">Skor: <?php echo $_SESSION['score']; ?>/100</div>

<div class="settings-btn-container">
    <button class="settings-btn" onclick="window.location.href='setting.php'">Tetapan</button>
</div>

<div class="container">
    <h1>Question <?php echo $questionIndex + 1; ?></h1>
    <div class="question-container">
        <img src="<?php echo $currentQuestion['image']; ?>" alt="Image" class="question-image">
    </div>
    
    <div class="question-text">
        <p><?php echo $currentQuestion['question']; ?></p>
    </div>

    <form id="quizForm" method="POST" class="answers-container">
        <?php foreach ($currentQuestion['options'] as $option) : ?>
            <div class="answer-option">
                <label>
                    <input type="radio" name="answer" value="<?php echo $option; ?>" required onclick="submitForm()">
                    <?php echo $option; ?>
                </label>
            </div>
        <?php endforeach; ?>
    </form>

    <!-- Paparkan mesej jika ada -->
    <?php if ($message): ?>
        <div class="message" style="color: <?php echo $messageColor; ?>;">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>
</div>
</body>
</html>
