<?php
session_start();
require '../../intro/config.php'; // Include your database connection file

// Ensure the score and username exist
if (!isset($_SESSION['score'])) {
    $_SESSION['score'] = 0;
}
if (!isset($_SESSION['username'])) {
    die("Error: User not logged in."); // Handle unauthenticated users
}

$score = $_SESSION['score'];
$username = $_SESSION['username'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Save the score to the `happyhome` table
    $stmt = $conn->prepare("INSERT INTO happyhome (username, score) VALUES (?, ?) 
        ON DUPLICATE KEY UPDATE score = ?");
    $stmt->bind_param("sii", $username, $score, $score);
    if ($stmt->execute()) {
        header("Location: ../../murid5/indexTahun5.php");
        exit;
    } else {
        echo "Error saving score: " . $stmt->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Score - My Happy Home</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            background: #f9f9f9;
            margin: 0;
            padding: 0;
        }
        #score-container {
            margin-top: 100px;
        }
        h1 {
            font-size: 2.5rem;
            color: #333;
        }
        #final-score {
            font-size: 2rem;
            color: #4CAF50;
        }
        .btn {
            margin: 20px 10px;
            padding: 10px 20px;
            font-size: 1.2rem;
            color: white;
            background-color: #4CAF50;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
        }
        .btn:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <div id="score-container">
        <h1>Congratulations!</h1>
        <p id="final-score">Your final score is: <strong><?= $score ?>/100</strong></p>
        <form method="POST">
            <button type="submit" class="btn">Kembali Ke Halaman Utama</button>
        </form>
    </div>
</body>
</html>
