<?php 
session_start(); 
$_SESSION['score'] = 0; 
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Game - My Happy Home</title>
    <link rel="stylesheet" href="style.css">
    <script>
        let score = 0;
        let currentLevel = 1;

        function updateScore(points) {
            score += points;
            document.getElementById('score').innerText = `Score: ${score}/100`;
        }

        function checkMatch(item, room) {
    const correctRoom = {
        "pillow": "bedroom",
        "plate": "kitchen",
        "tv": "livingroom",
        "toothbrush": "bathroom",
        "lamp": "bedroom",
        "spoon": "kitchen",
        "sofa": "livingroom",
        "mirror": "bathroom",
        "clock": "livingroom",
        "chair": "kitchen"
    };

    if (correctRoom[item] === room) {
        updateScore(10); // Add points for correct answers
        showFeedback("Correct!", "correct");
    } else {
        showFeedback("You are wrong"); // Show feedback for incorrect answers
    }

    // Proceed to the next level regardless of the answer
    nextLevel();
}


        function nextLevel() {
            currentLevel++;
            if (currentLevel > 10) {
                saveScore();
            } else {
                showLevel(currentLevel);
            }
        }

        function saveScore() {
            fetch('save_score.php', {
                method: 'POST',
                body: JSON.stringify({ score: score }),
                headers: { 'Content-Type': 'application/json' }
            }).then(() => {
                location.href = 'score.php';
            });
        }

        function updateScore(points) {
            score += points;
            document.getElementById('score').innerText = `Score: ${score}/100`;

            // Save score to the session using AJAX
            fetch('update_score.php', {
                method: 'POST',
                body: JSON.stringify({ score: score }),
                headers: { 'Content-Type': 'application/json' }
            });
        }

        function showLevel(level) {
            document.querySelectorAll('.level').forEach(lvl => lvl.style.display = 'none');
            document.getElementById(`level-${level}`).style.display = 'block';
        }

        function showFeedback(message, status) {
    const feedback = document.createElement('div');
    feedback.className = `feedback ${status}`;
    feedback.innerText = message;

    // Style the feedback element for visibility
    feedback.style.position = 'fixed';
    feedback.style.top = '50%';
    feedback.style.left = '50%';
    feedback.style.transform = 'translate(-50%, -50%)';
    feedback.style.padding = '20px';
    feedback.style.backgroundColor = status === 'correct' ? 'green' : 'red';
    feedback.style.color = '#fff';
    feedback.style.fontSize = '1.5em';
    feedback.style.borderRadius = '10px';
    feedback.style.boxShadow = '0 4px 8px rgba(0, 0, 0, 0.2)';
    feedback.style.textAlign = 'center';
    feedback.style.zIndex = '1000';

    document.body.appendChild(feedback);

    // Remove the feedback after 1.5 seconds
    setTimeout(() => feedback.remove(), 1500);
}


        window.onload = function() {
            showLevel(1);
        };
    </script>
</head>
<body>
<video autoplay loop muted id="background-video">
        <source src="bg3.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>
    <div id="top-bar">
        <div id="score">Score: 0/100</div>
        <button id="settings-button" onclick="window.location.href='setting.php'">⚙️ Settings</button>

    </div>
    

        <div id="game1-container">
        <!-- Level 1 -->
        <div class="level" id="level-1">
            <h2>Match the item to the correct room!</h2>
            <img src="images/pillow.png" alt="Pillow" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('pillow', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('pillow', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('pillow', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('pillow', 'bathroom')">
            </div>
        </div>

        <!-- Level 2 -->
        <div class="level" id="level-2">
        <h2>Match the item to the correct room!</h2>
            <img src="images/plate.png" alt="Plate" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('plate', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('plate', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('plate', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('plate', 'bathroom')">
            </div>
        </div>

        <!-- Level 3 -->
        <div class="level" id="level-3">
        <h2>Match the item to the correct room!</h2>
            <img src="images/tv.png" alt="TV" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('tv', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('tv', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('tv', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('tv', 'bathroom')">
            </div>
        </div>

        <!-- Level 4 -->
        <div class="level" id="level-4">
        <h2>Match the item to the correct room!</h2>
            <img src="images/toothbrush.png" alt="Toothbrush" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('toothbrush', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('toothbrush', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('toothbrush', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('toothbrush', 'bathroom')">
            </div>
        </div>

        <!-- Level 5 -->
        <div class="level" id="level-5">
        <h2>Match the item to the correct room!</h2>
            <img src="images/lamp.png" alt="Lamp" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('lamp', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('lamp', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('lamp', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('lamp', 'bathroom')">
            </div>
        </div>

        <!-- Level 6 -->
        <div class="level" id="level-6">
        <h2>Match the item to the correct room!</h2>
            <img src="images/spoon.png" alt="Spoon" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('spoon', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('spoon', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('spoon', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('spoon', 'bathroom')">
            </div>
        </div>

        <!-- Level 7 -->
        <div class="level" id="level-7">
        <h2>Match the item to the correct room!</h2>
            <img src="images/sofa.png" alt="Sofa" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('sofa', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('sofa', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('sofa', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('sofa', 'bathroom')">
            </div>
        </div>

        <!-- Level 8 -->
        <div class="level" id="level-8">
        <h2>Match the item to the correct room!</h2>
            <img src="images/mirror.png" alt="Mirror" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('mirror', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('mirror', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('mirror', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('mirror', 'bathroom')">
            </div>
        </div>

        <!-- Level 9 -->
        <div class="level" id="level-9">
        <h2>Match the item to the correct room!</h2>
            <img src="images/clock.png" alt="Clock" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('clock', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('clock', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('clock', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('clock', 'bathroom')">
            </div>
        </div>

        <!-- Level 10 -->
        <div class="level" id="level-10">
        <h2>Match the item to the correct room!</h2>
            <img src="images/chair.png" alt="Chair" class="item-image">
            <div class="options">
                <img src="images/bedroom.png" alt="Bedroom" class="room-image" onclick="checkMatch('chair', 'bedroom')">
                <img src="images/kitchen.png" alt="Kitchen" class="room-image" onclick="checkMatch('chair', 'kitchen')">
                <img src="images/livingroom.png" alt="Living Room" class="room-image" onclick="checkMatch('chair', 'livingroom')">
                <img src="images/bathroom.png" alt="Bathroom" class="room-image" onclick="checkMatch('chair', 'bathroom')">
            </div>
        </div>

    </div>
</body>
</html>
