<?php
session_start();
include '../../intro/config.php'; // Sambungan ke pangkalan data

// Pastikan skor tersedia
$score = isset($_GET['score']) ? intval($_GET['score']) : 0;
$totalQuestions = isset($_GET['total']) ? intval($_GET['total']) : 0;

// Dapatkan nama pengguna daripada sesi
$username = isset($_SESSION['username']) ? $_SESSION['username'] : 'Tidak Diketahui';

// Simpan skor ke pangkalan data apabila halaman dimuat
$query = "INSERT INTO sayurdanbuah (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($query);

if ($stmt) {
    $stmt->bind_param("si", $username, $score); // "si" = string dan integer
    if ($stmt->execute()) {
        // Skor telah berjaya disimpan, anda boleh menambah logik tambahan jika perlu
    } else {
        echo "Ralat semasa menyimpan skor: " . $stmt->error;
    }
    $stmt->close();
} else {
    echo "Ralat penyataan SQL: " . $conn->error;
}

$conn->close(); // Tutup sambungan ke pangkalan data
?>

<!DOCTYPE html>
<html lang="ms">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan Akhir</title>
    <link rel="stylesheet" href="style.css">
</head>

<body>
    <div class="container">
        <h1>Keputusan Akhir</h1>
        <p>Skor anda: <?= htmlspecialchars($score) ?> daripada <?= htmlspecialchars($totalQuestions * 10) ?></p>
        <a href="../../murid5/indexTahun5.php">Kembali ke menu utama</a>
    </div>
</body>

</html>
