<?php
session_start();
include '../../intro/config.php';

// Tetapkan zon waktu untuk memastikan waktu tempatan betul
date_default_timezone_set("Asia/Kuala_Lumpur");

// Senarai pakaian
$pakaian = [
    ["image" => "img/baju.png", "name" => "Baju", "audio" => "audio/baju.mp3"],
    ["image" => "img/seluar.png", "name" => "Seluar", "audio" => "audio/seluar.mp3"],
    ["image" => "img/topi.png", "name" => "Topi", "audio" => "audio/topi.mp3"],
    ["image" => "img/kasut.png", "name" => "Kasut", "audio" => "audio/kasut.mp3"],
    ["image" => "img/jaket.png", "name" => "Jaket", "audio" => "audio/jaket.mp3"],
    ["image" => "img/tudung.png", "name" => "Tudung", "audio" => "audio/tudung.mp3"],
    ["image" => "img/stokin.png", "name" => "Stokin", "audio" => "audio/stokin.mp3"],
    ["image" => "img/sarung_tangan.png", "name" => "Sarung Tangan", "audio" => "audio/sarung_tangan.mp3"],
    ["image" => "img/belt.png", "name" => "Tali Pinggang", "audio" => "audio/tali_pinggang.mp3"],
    ["image" => "img/glasses.png", "name" => "Kaca Mata", "audio" => "audio/kaca_mata.mp3"]
];

// Validasi dan tetapkan nilai
$level = isset($_GET['level']) && is_numeric($_GET['level']) ? (int)$_GET['level'] : 0;
$score = isset($_GET['score']) && is_numeric($_GET['score']) ? (int)$_GET['score'] : 0;
$totalScore = count($pakaian) * 10; // Skor maksimum ialah 100

// Pastikan pengguna log masuk
if (!isset($_SESSION['username'])) {
    die("Sila log masuk terlebih dahulu.");
}

// Rekod masa mula untuk level 0
if ($level === 0 && !isset($_SESSION['record_id'])) {
    $username = $_SESSION['username'];
    $masa_mula = date("H:i:s"); // Masa dalam format jam:minit:saat
    $date = date("Y-m-d");      // Tarikh dalam format tahun-bulan-hari

    $sql = "INSERT INTO bajucantik (username, score, `date`, masa_mula) VALUES (?, ?, ?, ?)";   
    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("ssss", $username, $score, $date, $masa_mula);
        if ($stmt->execute()) {
            $_SESSION['record_id'] = $stmt->insert_id;
        } else {
            echo "Ralat merekod masa mula: " . $stmt->error;
        }
        $stmt->close();
    } else {
        echo "Ralat penyediaan penyataan: " . $conn->error;
    }
}

// Header lokasi jika tamat
if ($level >= count($pakaian)) {
    header("Location: score.php?score=$score");
    exit;
}

// Pilihan jawapan
$current = $pakaian[$level];
$wrongChoices = array_filter($pakaian, fn($item) => $item['name'] !== $current['name']);
shuffle($wrongChoices);
$wrongChoices = array_slice($wrongChoices, 0, 3);
$choices = array_merge([$current], $wrongChoices);
shuffle($choices);
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permainan Mengenal Pakaian</title>
    <link rel="stylesheet" href="style.css">
    <script>
        function showMessage(element) {
            const messageDiv = document.getElementById('message');
            const isCorrect = element.dataset.correct === "true"; 
            messageDiv.innerText = isCorrect ? "Tahniah! Jawapan kamu betul!" : "Cuba lagi! Kamu pasti boleh!";
            messageDiv.style.color = isCorrect ? "green" : "red";
            messageDiv.style.fontSize = "20px";
            messageDiv.style.fontWeight = "bold";
            messageDiv.style.display = "block";

            // Simpan pautan untuk soalan seterusnya
            const nextUrl = element.dataset.next;

            setTimeout(() => {
                window.location.href = nextUrl;
            }, 2000);
        }
    </script>
</head>

<body>
    <!-- Header dengan skor -->
    <div class="header">
        <div class="score">Skor: <?= $score ?>/<?= $totalScore ?></div>
        <a href="settings.php" class="setting-btn">Tetapan</a>
    </div>

    <audio id="question-audio" src="<?= $current['audio'] ?>" autoplay></audio>

    <div class="game-container">
        <h1>SOALAN <?= $level + 1 ?></h1>
        <img src="<?= $current['image'] ?>" alt="Pakaian <?= $current['name'] ?>">
        <p>Apakah nama pakaian ini?</p>

        <!-- Mesej Maklum Balas -->
        <div id="message" style="display: none; text-align: center; margin-top: 15px;"></div>

        <!-- Pilihan Jawapan -->
        <div class="choices">
            <?php foreach ($choices as $choice): ?>
                <a href="#" 
                   onclick="event.preventDefault(); showMessage(this);" 
                   data-next="game.php?level=<?= $level + 1 ?>&score=<?= $choice['name'] === $current['name'] ? $score + 10 : $score ?>"
                   data-correct="<?= $choice['name'] === $current['name'] ? 'true' : 'false' ?>"
                   class="choice">
                    <?= $choice['name'] ?>
                </a>
            <?php endforeach; ?>
        </div>
    </div>
</body>
</html>
