<?php
session_start();
require_once '../../intro/config.php'; // Ensure this includes the connection to the database

// Retrieve score from session
$score = $_SESSION['score'];

// Check if username exists in the session
$username = $_SESSION['username']; // Assuming 'username' is stored in session after login

// Insert score into the database (table: ukur)
if (isset($username)) {
    // Prepare the SQL query
    $sql = "INSERT INTO ukur (username, score) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);
    
    // Bind parameters and execute the query
    $stmt->bind_param("si", $username, $score); // 's' for string, 'i' for integer
    $stmt->execute();
    $stmt->close();
}

// Optionally reset the session score after saving it
unset($_SESSION['score']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skor</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container fade-in">
        <h1>Skor Akhir Anda</h1>
        <h2><?php echo $score; ?>/100</h2>
        <a href="index.php" class="btn">Main Lagi</a>
    </div>
</body>
</html>
