<!-- score.php -->
<?php
// Mula sesi
session_start();

// Sertakan fail config.php untuk sambungan pangkalan data
include '../../intro/config.php';  // Pastikan path ke config.php betul

// Semak jika skor dihantar melalui POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['score'])) {
    $_SESSION['score'] = intval($_POST['score']); // Simpan skor dalam sesi
}

// Tetapkan skor kepada 0 jika tiada skor dalam sesi
$score = isset($_SESSION['score']) ? $_SESSION['score'] : 0;

// Semak jika nama pengguna sudah disimpan dalam sesi
$username = isset($_SESSION['username']) ? $_SESSION['username'] : "Tetamu";

// Jika pengguna bukan 'Tetamu' dan skor ada, simpan skor ke dalam pangkalan data
if ($username !== "Tetamu" && $score > 0) {
    $stmt = $conn->prepare("INSERT INTO sirah (username, score) VALUES (?, ?)");
    $stmt->bind_param("si", $username, $score);

    // Semak jika penyimpanan berjaya
    if ($stmt->execute()) {
        echo "";
    } else {
        echo "Gagal menyimpan skor.";
    }

    // Tutup penyambung dan statement
    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Keputusan Kuiz</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f9f9f9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .score-container {
            background-color: #fff;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .score-container h1 {
            font-size: 24px;
            margin-bottom: 20px;
        }
        .score-container p {
            font-size: 20px;
            margin-bottom: 20px;
        }
        .score-container .button {
            background-color: #4CAF50;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
        }
        .score-container .button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>

<div class="score-container">
    <h1>Keputusan Kuiz</h1>
    <p>Nama Pengguna: <?php echo htmlspecialchars($username); ?></p>
    <p>Markah anda: <?php echo htmlspecialchars($score); ?>/100</p>
    <a href="../../murid5/indexTahun5.php" class="button">Kembali Ke Halaman Utama</a>
</div>

</body>
</html>