<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kuiz Pilihan Jawapan</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5d5eb, #fcb69f);
            color: #333;
            margin: 0;
            padding: 0;
            overflow: hidden;
            transition: all 0.3s ease-in-out;
        }
        .kuiz-page {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            padding: 20px;
            box-sizing: border-box;
        }
        .score-display {
            position: absolute;
            top: 10px;
            left: 20px;
            font-size: 1.2em;
            font-weight: bold;
            background: white;
            color: green;
            padding: 10px 20px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            animation: fadeIn 1s ease-in-out;
        }
        .settings-button {
            position: absolute;
            top: 10px;
            right: 20px;
            background: #ff6f61;
            color: white;
            border: none;
            border-radius: 50%;
            padding: 12px 15px;
            cursor: pointer;
            font-size: 1.2em;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            transition: transform 0.3s, background 0.3s;
        }
        .settings-button:hover {
            background: #ff856e;
            transform: scale(1.1);
        }
        .kuiz-title {
            font-size: 2.8em;
            margin-bottom: 20px;
            color: #ff6f61;
            text-shadow: 3px 3px 6px rgba(0, 0, 0, 0.2);
            animation: fadeInDown 1s ease-in-out;
        }
        .kuiz-container {
            background: rgba(255, 255, 255, 0.9);
            padding: 25px;
            border-radius: 15px;
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.2);
            width: 90%;
            max-width: 650px;
            text-align: center;
            transition: all 0.3s ease-in-out;
        }
        .kuiz-container:hover {
            transform: translateY(-5px);
        }
        button {
            background: linear-gradient(135deg, #ff6f61, #ff856e);
            color: white;
            border: none;
            border-radius: 8px;
            padding: 12px 25px;
            font-size: 1em;
            cursor: pointer;
            margin: 20px 10px;
            transition: transform 0.3s, background 0.3s;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        button:hover {
            background: linear-gradient(135deg, #ff856e, #ff6f61);
            transform: translateY(-3px) scale(1.1);
        }
        p {
            font-size: 1.2em;
            margin-bottom: 25px;
        }
    </style>
</head>
<body class="kuiz-page">
    <div class="score-display" id="scoreDisplay">Skor: 0/100</div>

    <button class="settings-button" onclick="window.location.href='setting.php'">⚙️</button>

    <div class="kuiz-container">
        <h1 class="kuiz-title">Kuiz Pilihan Jawapan</h1>
        <div id="quizContainer">
            <!-- Soalan akan dipaparkan di sini -->
        </div>
    </div>

    <script>
        function openSettings() {
            alert("Halaman Tetapan masih dalam pembangunan!");
        }

        const questions = [
        
        {
            text: "1. Siapakah nama bapa Nabi Muhammad SAW?",
            choices: ["Abdullah", "Abu Talib"],
            correct: "Abdullah"
        },
        {
            text: "2. Siapakah nama ibu Nabi Muhammad SAW?",
            choices: ["Aminah", "Fatimah"],
            correct: "Aminah"
        },
        {
            text: "3. Siapakah nama datuk Nabi Muhammad SAW?",
            choices: ["Abdul Muttalib", "Abu Talib"],
            correct: "Abdul Muttalib"
        },
        {
            text: "4. Siapakah isteri pertama Nabi Muhammad SAW?",
            choices: ["Khadijah", "Aisyah"],
            correct: "Khadijah"
        },
        {
            text: "5. Siapakah nama anak lelaki Nabi Muhammad SAW?",
            choices: ["Qasim", "Ali"],
            correct: "Qasim"
        },
        {
            text: "6. Siapakah nama cucu Nabi Muhammad SAW yang pertama?",
            choices: ["Hasan", "Husain"],
            correct: "Hasan"
        },
        {
            text: "7. Apakah nama ibu saudara Nabi Muhammad SAW yang terkenal?",
            choices: ["Shifa", "Atikah"],
            correct: "Atikah"
        },
        {
            text: "8. Siapakah yang menjadi khalifah setelah Nabi Muhammad SAW?",
            choices: ["Abu Bakr", "Umar"],
            correct: "Abu Bakr"
        },
        {
            text: "9. Apakah nama tempat Nabi Muhammad SAW dilahirkan?",
            choices: ["Mekah", "Medina"],
            correct: "Mekah"
        },
        {
            text: "10. Apa nama peristiwa penting dalam sejarah Nabi Muhammad SAW?",
            choices: ["Hijrah", "Badr"],
            correct: "Hijrah"
        }
    ];
   

        let currentQuestion = 0;
        let score = 0;

        function loadQuestion() {
            const quizContainer = document.getElementById("quizContainer");
            quizContainer.innerHTML = "";

            if (currentQuestion < questions.length) {
                const question = questions[currentQuestion];
                const questionDiv = document.createElement("div");

                const questionText = document.createElement("p");
                questionText.textContent = question.text;
                questionDiv.appendChild(questionText);

                question.choices.forEach(choice => {
                    const button = document.createElement("button");
                    button.textContent = choice;
                    button.onclick = () => checkAnswer(choice);
                    questionDiv.appendChild(button);
                });

                quizContainer.appendChild(questionDiv);
            } else {
                goToScorePage();
            }
        }

        function checkAnswer(choice) {
            const question = questions[currentQuestion];
            if (choice === question.correct) {
                score += 10;
                updateScoreDisplay();
            }
            currentQuestion++;
            loadQuestion();
        }

        function updateScoreDisplay() {
            document.getElementById("scoreDisplay").textContent = `Skor: ${score}/100`;
        }

        function goToScorePage() {
            fetch("score.php", {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: `score=${encodeURIComponent(score)}`,
            })
            .then(() => {
                window.location.href = "score.php";
            })
            .catch(error => console.error("Error sending score:", error));
        }

        loadQuestion();
    </script>
</body>
</html>
