<?php
session_start();

// Reset score and feedback if "reset" parameter is present or if it's the first question
if (!isset($_POST['next_question']) || $_POST['next_question'] == 0) {
    $_SESSION['score'] = 0;
    $_SESSION['feedback'] = '';
}

// Define the questions and answers
$questions = [
    ['question' => '2 + 3 = ?', 'answers' => [4, 5, 6], 'correct_answer' => 5],
    ['question' => '6 - 1 = ?', 'answers' => [3, 4, 5], 'correct_answer' => 5],
    ['question' => '4 + 2 = ?', 'answers' => [5, 6, 7], 'correct_answer' => 6],
    ['question' => '7 - 4 = ?', 'answers' => [3, 4, 5], 'correct_answer' => 3],
    ['question' => '3 + 2 = ?', 'answers' => [4, 5, 6], 'correct_answer' => 5],
    ['question' => '8 - 6 = ?', 'answers' => [1, 2, 3], 'correct_answer' => 2],
    ['question' => '5 + 3 = ?', 'answers' => [7, 8, 9], 'correct_answer' => 8],
    ['question' => '9 - 5 = ?', 'answers' => [3, 4, 5], 'correct_answer' => 4],
    ['question' => '1 + 4 = ?', 'answers' => [4, 5, 6], 'correct_answer' => 5],
    ['question' => '10 - 7 = ?', 'answers' => [2, 3, 4], 'correct_answer' => 3]
];

// Get the current question number (starting at 0)
$next_question = isset($_POST['next_question']) ? $_POST['next_question'] : 0;

// Get the current question
$question = $questions[$next_question];

// Process form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $answer = isset($_POST['answer']) ? $_POST['answer'] : null;
    $correct_answer = $_POST['correct_answer'];

    // Check answer correctness
    if ($answer == $correct_answer) {
        $_SESSION['score'] += 10;
        $_SESSION['feedback'] = "Tahniah anda Betul, Mari ke soalan seterusnya!";
    } else {
        $_SESSION['feedback'] = "Maaf anda salah, Mari ke soalan seterusnya!";
    }

    // Move to the next question
    $next_question++;

    // Redirect to the next question or show score
    if ($next_question < count($questions)) {
        $question = $questions[$next_question];
    } else {
        header('Location: score.php');
        exit();
    }
}

?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permainan Tambah dan Tolak</title>
    <link rel="stylesheet" href="style.css">
    <script>
        // Wait for the DOM to load before running the script
        document.addEventListener('DOMContentLoaded', function() {
            // Set a timeout to hide the feedback message after 3 seconds
            setTimeout(function() {
                document.getElementById('feedback-message').style.display = 'none';
            }, 3000); // 3000 milliseconds = 3 seconds
        });
    </script>
</head>
<body class="game-page">
    <!-- Score and Settings -->
    <div class="header">
        <div class="score">Skor: <?php echo isset($_SESSION['score']) ? $_SESSION['score'] : 0; ?>/100</div>
        <div class="settings">
            <a href="settings.php" class="settings-button">Tetapan</a>
        </div>
    </div>

    <!-- Question Section -->
    <center><h1>Soalan <?php echo $next_question + 1; ?></h1></center>
    <div id="feedback-message" style="font-size: 20px; font-weight: bold; margin-bottom: 20px; color: <?php echo $_SESSION['feedback'] === "Tahniah anda Betul, Mari ke soalan seterusnya!" ? 'green' : 'red'; ?>">
        <?php echo $_SESSION['feedback']; ?>
    </div>

    <!-- Combined Question and Answer Container -->
    <div class="question-answer-container">
        <div class="question-container">
            <p><?php echo $question['question']; ?></p>
        </div>

        <div class="answers-container">
            <form method="post">
                <?php foreach ($question['answers'] as $answer): ?>
                    <button 
                        type="submit" 
                        class="answer-button" 
                        name="answer" 
                        value="<?php echo $answer; ?>">
                        <?php echo $answer; ?>
                    </button>
                <?php endforeach; ?>

                <input type="hidden" name="correct_answer" value="<?php echo $question['correct_answer']; ?>">
                <input type="hidden" name="next_question" value="<?php echo $next_question; ?>">
            </form>
        </div>
    </div>
</body>
</html>
