<?php
// save_score.php

// Start the session to access session variables
session_start();

// Include the database configuration file
include('../../intro/config.php');  // Update the path as needed

try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Check if user is logged in
    if (!isset($_SESSION['username'])) {
        header("Location: login.php"); // Redirect to login if not logged in
        exit;
    }
    
    // Get the username from the session
    $username = $_SESSION['username'];

    // Check if score is passed via POST request
    if (isset($_POST['score'])) {
        $score = $_POST['score']; // Get the score from POST

        // Prepare and execute the insert statement
        $stmt = $conn->prepare("INSERT INTO family (username, score) VALUES (:username, :score)");
        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':score', $score);
        $stmt->execute();
        
        echo "Score saved successfully!";
    } else {
        echo "Invalid data received. Score is missing.";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
