    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>My Loving Family Game</title>
        <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600&display=swap" rel="stylesheet">
        <link rel="stylesheet" href="style.css">
    </head>
    <body>

    <!-- Background Video -->
    <video class="background-video" autoplay muted loop>
        <source src="family.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>

    <audio id="background-music" autoplay loop>
        <source src="audio/song.mp3" type="audio/mpeg">
        Your browser does not support the audio element
    </audio>

    <!-- Menu Page -->
    <div class="menu-container" id="menu-page">
        <h1 class="menu-title">Welcome to My Loving Family Game</h1>
        <button class="play-button" onclick="startGame()">Play</button>
    </div>

    <!-- Game Page -->
    <div class="game-container hidden" id="game-page">
        <div class="score" id="score">Score: 0 /100</div>
        <button class="setting-button" onclick="window.location.href='setting.php'">Settings</button>
        <div class="question fade" id="question">
        What do we do together? <span class="highlight">We eat dinner together.</span>
        </div>
        <center><h2>choose the answer</h2></center><br><br>
        <div id="choices" class="choices fade">
            <!-- Choices will be dynamically inserted here -->
        </div>
        <div id="message" class="message"></div>
        <button id="back-to-menu-btn" class="restart-btn" onclick="backToMenu()">Back to Menu</button>
    </div>

    <script>
        // Switch to Game Page
        function startGame() {
            document.getElementById("menu-page").classList.add("hidden");
            document.getElementById("game-page").classList.remove("hidden");
            loadQuestion();
        }

            // Game Data
    const questions = [
        {
            question: "What do we do together? We eat dinner together.",
            choices: [
                { text: "Family eating dinner", image: "img/makan.jpg", correct: true },
                { text: "Family playing ball", image: "img/ball.jpg", correct: false },
                { text: "Family reading books", image: "img/book.jpg", correct: false }
            ]
        },
        {
            question: "What do we do together? We play in the park.",
            choices: [
                { text: "Family playing in the park", image: "img/park.jpg", correct: true },
                { text: "Family sleeping", image: "img/sleep.jpg", correct: false },
                { text: "Family eating dinner", image: "img/makan.jpg", correct: false }
            ]
        },
        {
            question: "What do we do together? We read books.",
            choices: [
                { text: "Family watching TV", image: "img/tv.jpg", correct: false },
                { text: "Family reading books", image: "img/book.jpg", correct: true },
                { text: "Family playing ball", image: "img/ball.jpg", correct: false }
            ]
        },
        {
            question: "What do we do together? We clean the house.",
            choices: [
                { text: "Family walking outside", image: "img/walk.jpg", correct: false },
                { text: "Family cleaning the house", image: "img/clean.jpg", correct: true },
                { text: "Family celebrating a birthday", image: "img/birthday.png", correct: false }
            ]
        },
        {
            question: "What do we do together? We go on a family trip.",
            choices: [
                { text: "Family going on a trip", image: "img/trip.jpeg", correct: true },
                { text: "Family cleaning the house", image: "img/clean.jpg", correct: false },
                { text: "Family riding bicycles", image: "img/bike.png", correct: false }
            ]
        },
        {
            question: "What do we do together? We bake cookies.",
            choices: [
                { text: "Family baking cookies", image: "img/bake.png", correct: true },
                { text: "Family swimming", image: "img/swim.png", correct: false },
                { text: "Family watching movies", image: "img/movie.png", correct: false }
            ]
        },
        {
            question: "What do we do together? We ride bicycles.",
            choices: [
                { text: "Family sitting in a car", image: "img/car.png", correct: false },
                { text: "Family riding bicycles", image: "img/bike.png", correct: true },
                { text: "Family playing in the park", image: "img/park.jpg", correct: false }
            ]
        },
        {
            question: "What do we do together? We celebrate a birthday.",
            choices: [
                { text: "Family playing video games", image: "img/game.png", correct: false },
                { text: "Family celebrating a birthday", image: "img/birthday.png", correct: true },
                { text: "Family reading books", image: "img/book.jpg", correct: false }
            ]
        },
        {
            question: "What do we do together? We sing songs.",
            choices: [
                { text: "Family singing songs", image: "img/sing.png", correct: true },
                { text: "Family painting together", image: "img/draw.png", correct: false },
                { text: "Family baking cookies", image: "img/bake.png", correct: false }
            ]
        },
        {
            question: "What do we do together? We watch movies.",
            choices: [
                { text: "Family watching movies", image: "img/movie.png", correct: true },
                { text: "Family eating snacks", image: "img/snack.png", correct: false },
                { text: "Family playing in the park", image: "img/park.jpg", correct: false }
            ]
        }
    ];


        let currentQuestion = 0;
        let score = 0;
        const totalScore = 100; // Maximum score
        const scorePerQuestion = totalScore / questions.length; // Score per question

        const questionElement = document.getElementById("question");
        const choicesElement = document.getElementById("choices");
        const scoreElement = document.getElementById("score");
        const messageElement = document.getElementById("message");

        // Load Question
        function loadQuestion() {
            const question = questions[currentQuestion];
            questionElement.textContent = question.question;
            choicesElement.innerHTML = "";

            question.choices.forEach((choice, index) => {
                const button = document.createElement("button");
                button.className = "choice";
                button.innerHTML = `<img src="${choice.image}" alt="${choice.text}"><div>${choice.text}</div>`;
                button.onclick = () => checkAnswer(index);
                choicesElement.appendChild(button);
            });
        }

        // Check Answer
function checkAnswer(index) {
    console.log("Checking answer for index: ", index); // Log index pilihan
    const correct = questions[currentQuestion].choices[index].correct;
    console.log("Is the answer correct? ", correct); // Log jika jawapan betul

    messageElement.style.color = correct ? "green" : "red";
    messageElement.textContent = correct
        ? "Correct! Moving to the next question."
        : "Wrong. Moving to the next question.";
    messageElement.style.opacity = 1;
    messageElement.style.transform = "scale(1)";

    // Update score if the answer is correct
    if (correct) {
        score += 10; // Add +10 for correct answer
        console.log("Updated score: ", score); // Log updated score
        scoreElement.textContent = `Score: ${score} / ${totalScore}`;
    }

    // Proceed to the next question
    currentQuestion++;

    if (currentQuestion < questions.length) {
        setTimeout(() => {
            loadQuestion();
            resetMessage();
        }, 1000);
    } else {
        endGame();
    }
}

        // Reset Message
        function resetMessage() {
            messageElement.style.opacity = 0;
            messageElement.style.transform = "scale(0.9)";
        }

        // End Game
        function endGame() {
            questionElement.textContent = `You scored ${score} out of ${totalScore}!`;
            choicesElement.innerHTML = "";
            messageElement.textContent = ""; // Clear "Correct!" message
            document.getElementById("back-to-menu-btn").style.display = "inline-block"; // Show Back to Menu button
        }

        // Function to send the score and username to the backend when going back to the menu
    function saveScoreToDatabase() {
        const username = "user_example"; // Replace with the actual logged-in username
        const userScore = score; // Score is tracked in the game

        const xhr = new XMLHttpRequest();
        xhr.open("POST", "save_score.php", true);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                console.log("Score saved successfully");
            }
        };
        xhr.send("username=" + username + "&score=" + userScore);
    }

    /// Back to Menu function where we save the score before navigating
    function backToMenu() {
        // Save score to database
        saveScoreToDatabase();

        // Redirect to the specified page
        window.location.href = "../../murid5/indexTahun5.php"; 

        // If you want to hide the game page or do other things before navigating, 
        // you can keep the reset logic, but the redirection will happen first.
        document.getElementById("menu-page").classList.remove("hidden");
        document.getElementById("game-page").classList.add("hidden");

        // Reset game state if necessary
        currentQuestion = 0;
        score = 0;
        scoreElement.textContent = `Score: 0 / ${totalScore}`;
        document.getElementById("back-to-menu-btn").style.display = "none";
    }

    </script>
    </body>
    </html>
