<?php
session_start();

// Termasuk fail config.php untuk sambungan ke pangkalan data
include('../../intro/config.php');

// Semak jika semua parameter diterima
if (!isset($_GET['username'], $_GET['score'])) {
    die("Ralat: Data tidak lengkap. Pastikan username dan score dihantar.");
}

// Ambil data dari URL
$username = htmlspecialchars($_GET['username']); // Elakkan XSS
$score = intval($_GET['score']); // Pastikan nilai integer

// Debug untuk pastikan data diterima
if (empty($username) || $score <= 0) {
    die("Ralat: Data tidak sah. Username: $username, Score: $score");
}

// Masukkan data ke dalam pangkalan data
$sql = "INSERT INTO mengenalBentuk (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($sql);

// Semak jika penyediaan berjaya
if (!$stmt) {
    die("Ralat penyediaan pernyataan: " . $conn->error);
}

// Bind parameter dan jalankan pernyataan
$stmt->bind_param("si", $username, $score); // s: string, i: integer
if ($stmt->execute()) {
    echo "Markah telah disimpan dengan jayanya!";
} else {
    echo "Ralat: " . $stmt->error;
}

// Tutup sambungan
$stmt->close();
$conn->close();
?>
