<?php
session_start();

// Periksa jika pengguna sudah log masuk
if (!isset($_SESSION['username'])) {
    echo "Ralat: Pengguna tidak log masuk.";
    exit;
}

// Ambil nama pengguna dari sesi
$name = isset($_SESSION['name']) ? htmlspecialchars($_SESSION['name']) : htmlspecialchars($_SESSION['username']);
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mari Mengenal Bentuk - Tahun 5 Tadika</title>
    <link rel="stylesheet" type="text/css" href="style.css">
</head>
<body>
    <div class="menu">
        <h1>Selamat Datang ke Permainan Mengenal Bentuk!</h1>
        <h2>Selamat datang, <?php echo $name; ?>!</h2>
        <form action="game.php" method="GET">
            <button type="submit" id="startButton">Mula Permainan</button>
        </form>
    </div>

    <!-- Muzik latar -->
    <audio id="backgroundMusic" loop autoplay>
        <source src="backgroundSong.mp3" type="audio/mpeg">
        Your browser does not support the audio element.
    </audio>

    <script>
        // Mainkan muzik secara automatik
        const music = document.getElementById('backgroundMusic');
        music.play().catch(() => console.log("Muzik tidak dimainkan secara automatik."));
    </script>
</body>
</html>
