<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "Ralat: Pengguna tidak log masuk.";
    exit; // Stop the script execution if user is not logged in
}
$userName = htmlspecialchars($_SESSION['username']); // Prevent XSS attacks
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Markah Anda</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Markah Anda</h1>
        <p>Tahniah, <span id="userName"><?php echo $userName; ?></span>! Anda mendapat markah <span id="finalScore">0</span>!</p>
        <button onclick="saveScoreAndRestart()">Kembali Ke Halaman Utama</button>
    </div>

    <script>
        // Dapatkan markah dari URL
        function getFinalScoreFromURL() {
            const params = new URLSearchParams(window.location.search);
            return parseInt(params.get('score')) || 0;
        }

        // Kemas kini markah akhir
        const score = getFinalScoreFromURL();
        document.getElementById('finalScore').textContent = score;

        // Fungsi untuk menyimpan markah ke pangkalan data dan mula semula permainan
        function saveScoreAndRestart() {
            const tahap = 10; // Tahap permainan (ubah jika diperlukan)
            
            // Hantar markah ke pangkalan data
            fetch(`submit_score.php?score=${score}&username=${encodeURIComponent('<?php echo $userName; ?>')}&tahap=${tahap}`)
                .then(response => response.text())
                .then(result => {
                    console.log(result); // Log respons dari server
                    alert(result); // Paparkan hasil untuk debugging
                    if (result.includes('jayanya')) {
                        window.location.href = '../../murid5/indexTahun5.php'; 
                    } else {
                        alert('Gagal menyimpan markah.');
                    }
                })
                .catch(error => {
                    console.error('Ralat menghantar markah:', error);
                    alert('Gagal menyimpan markah. Sila cuba lagi.');
                });
        }
    </script>
</body>
</html>
