<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kenali Haiwan Kecil</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <video id="background-video" autoplay muted loop>
        <source src="vid.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>
    <audio id="background-audio" autoplay loop>
        <source src="song/sound.mp3" type="audio/mp3">
        Your browser does not support the audio element.
    </audio>

    <!-- Button for Settings -->
    <div class="settings-btn-container">
        <button class="settings-btn" onclick="goToSettings()">Tetapan</button>
    </div>

    <!-- Menu Page -->
    <div id="menu-container" class="container">
        <div class="title">Kenali Haiwan Kecil</div>
        <div class="option-container">
    
        </div>
    </div>

    <!-- Game Page -->
    <div id="game-container" class="container">
        <div class="title">Apakah haiwan ini?</div>
        <div class="image-container" id="image-container"></div>
        <div class="options-container" id="options-container"></div>
        <div class="congratulations" id="congratulations">Tahniah! Jawapan Betul</div>
        <div class="wrong-message" id="wrong-message">anda salah</div>
        <div class="score" id="score">Skor: 0/100</div>
    </div>

    <!-- Score Page -->
    <div id="score-container" class="container" style="display:none;">
        <div class="title">Skor Anda</div>
        <p class="score" id="final-score">Skor: 0/100</p>
        <button onclick="goToLearningApp()">Kembali ke Aplikasi Pembelajaran</button>
    </div>

    <!-- Settings Page -->
    <div id="settings-container" class="container">
        <div class="title">Tetapan</div>
        <button class="settings-btn" onclick="goToSettings()">Tetapan</button>
        <button class="settings-btn" onclick="goBackToGame()">Kembali ke Permainan</button>
    </div>

    <!-- Form Tersembunyi -->
    <form id="save-score-form" method="POST" action="save_score.php" style="display: none;">
        <input type="hidden" id="username" name="username" value="pelajar123"> <!-- Ganti dengan username dinamis -->
        <input type="hidden" id="score-input" name="score">
    </form>

    <script>
        let currentLevel = 1;
let score = 0;
const totalQuestions = 10;  // Total number of questions

const questions = [
    { image: 'image/hamster.jpg', correctAnswer: 'A', options: ['Hamster', 'Kucing', 'Arnab', 'Semut'], sound: 'hamster' },
    { image: 'image/arnab.jpg', correctAnswer: 'C', options: ['Hamster', 'Kucing', 'Arnab', 'Semut'], sound: 'arnab' },
    { image: 'image/semut.jpg', correctAnswer: 'D', options: ['Hamster', 'Kucing', 'Arnab', 'Semut'], sound: 'semut' },
    { image: 'image/ayam.jpg', correctAnswer: 'A', options: ['Ayam', 'Burung', 'Cicak', 'Kucing'], sound: 'ayam' },
    { image: 'image/burung.jpg', correctAnswer: 'B', options: ['Ayam', 'Burung', 'Cicak', 'Kucing'], sound: 'burung' },
    { image: 'image/cicak.jpg', correctAnswer: 'C', options: ['Ayam', 'Burung', 'Cicak', 'Kucing'], sound: 'cicak' },
    { image: 'image/kucing.jpg', correctAnswer: 'D', options: ['Ayam', 'Burung', 'Cicak', 'Kucing'], sound: 'kucing' },
    { image: 'image/kumbang.jpg', correctAnswer: 'A', options: ['Kumbang', 'Lebah', 'Rama-rama', 'Tikus'], sound: 'kumbang' },
    { image: 'image/lebah.jpg', correctAnswer: 'B', options: ['Kumbang', 'Lebah', 'Rama-rama', 'Tikus'], sound: 'lebah' },
    { image: 'image/rama.jpeg', correctAnswer: 'C', options: ['Kumbang', 'Lebah', 'Rama-rama', 'Tikus'], sound: 'ramarama' },
    
];  

function playSound(sound) {
    const audio = new Audio(`sounds/${sound}.mp3`);
    audio.play();
}

function loadQuestion() {
    const question = questions[currentLevel - 1];
    document.getElementById('image-container').innerHTML = `<img src="${question.image}" alt="Image" width="300" />`;
    document.getElementById('options-container').innerHTML = `
        <button onclick="checkAnswer('${question.correctAnswer}', 'A')">${question.options[0]}</button>
        <button onclick="checkAnswer('${question.correctAnswer}', 'B')">${question.options[1]}</button>
        <button onclick="checkAnswer('${question.correctAnswer}', 'C')">${question.options[2]}</button>
        <button onclick="checkAnswer('${question.correctAnswer}', 'D')">${question.options[3]}</button>
    `;
    playSound(question.sound);
}

function checkAnswer(correctAnswer, selectedAnswer) {
    const congratulations = document.getElementById('congratulations');
    const wrongMessage = document.getElementById('wrong-message');

    if (correctAnswer === selectedAnswer) {
        score += 10; // Increment by 10 for each correct answer
        document.getElementById('score').textContent = `Skor: ${score}/100`;  // Update score display
        congratulations.style.display = 'block';
        setTimeout(() => {
            congratulations.style.display = 'none';
            currentLevel++;
            if (currentLevel > questions.length) {
                endGame();
            } else {
                loadQuestion();
            }
        }, 2000);
    } else {
        wrongMessage.style.display = 'block';
        setTimeout(() => {
            wrongMessage.style.display = 'none';
            currentLevel++; // Go to next question immediately after wrong answer
            if (currentLevel > questions.length) {
                endGame();
            } else {
                loadQuestion(); // Load next question
            }
        }, 2000);
    }
}


function endGame() {
    document.getElementById('game-container').style.display = 'none';
    document.getElementById('score-container').style.display = 'block';
    document.getElementById('final-score').textContent = `Skor Anda: ${score}/100`;
}

function startGame() {
    document.getElementById('menu-container').style.display = 'none';
    document.getElementById('game-container').style.display = 'block';
    loadQuestion();
}

function goToSettings() {
    document.getElementById('menu-container').style.display = 'none';
    document.getElementById('settings-container').style.display = 'flex';
}

function goBackToMenu() {
    document.getElementById('settings-container').style.display = 'none';
    document.getElementById('menu-container').style.display = 'flex';
}

function goBackToGame() {
    document.getElementById('settings-container').style.display = 'none';
    document.getElementById('game-container').style.display = 'block';
}

function goToLearningApp() {
    document.getElementById('score-input').value = score;
    document.getElementById('save-score-form').submit();
}
</script>

</body>
</html>
