<?php
// Mulakan sesi PHP
session_start();

// Import fail sambungan ke pangkalan data
require '../../intro/config.php'; // Pastikan fail ini mempunyai sambungan $conn

// Semak jika sesi mempunyai username
if (!isset($_SESSION['username'])) {
    die(json_encode(['success' => false, 'message' => 'Pengguna tidak log masuk.']));
}

$username = $_SESSION['username']; // Ambil username dari sesi

// Dapatkan data daripada JSON POST
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['score'])) {
    $score = (int) $data['score'];

    // Gunakan prepared statement untuk mengelakkan SQL Injection
    $sql = "INSERT INTO ibadah (username, score) VALUES (?, ?)";

    $stmt = $conn->prepare($sql);
    
    if ($stmt) {
        $stmt->bind_param("si", $username, $score);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Gagal memasukkan data: ' . $stmt->error]);
        }

        // Tutup pernyataan
        $stmt->close();
    } else {
        echo json_encode(['success' => false, 'message' => 'Ralat penyediaan penyataan: ' . $conn->error]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Data tidak lengkap.']);
}

// Tutup sambungan
$conn->close();
?>
