<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Level 2 - Padankan Gambar dengan Jawapan</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <header>
        <!-- Skor di atas kiri -->
        <div class="score-container">
            <h3>Skor: <span id="score">0</span> / 100</h3>
        </div>
        <!-- Butang Tetapan di atas kanan -->
        <button class="settings-button" onclick="goToSettings()">Tetapan ⚙️</button>
    </header>

    <main>
        <h1>Level 2: Padankan Gambar dengan Jawapan</h1>
        <p style="font-size: 16px;">Klik pada gambar untuk memilih, kemudian klik pada jawapan yang sesuai. Padankan semua untuk mendapat tambahan 10 markah!</p>
        
            <br>

        <div class="game-container">
            <div class="image-container">
                <!-- Gambar dan susun atur -->
                <div class="image-box">
                    <img src="gambar/masjid.png" alt="Masjid" onclick="selectImage('Masjid', this)">
                    <p></p>
                </div>
                <div class="image-box">
                    <img src="gambar/alquran.png" alt="Al-Quran" onclick="selectImage('Al-Quran', this)">
                    <p></p>
                </div>
                <div class="image-box">
                    <img src="gambar/solat1.png" alt="Solat" onclick="selectImage('Solat', this)">
                    <p></p>
                </div>
                <div class="image-box">
                    <img src="gambar/zakat3.png" alt="Zakat" onclick="selectImage('Zakat', this)">
                    <p></p>
                </div>
                <div class="image-box">
                    <img src="gambar/haji.png" alt="Haji" onclick="selectImage('Haji', this)">
                    <p></p>
                </div>
                <div class="image-box">
                    <img src="gambar/doa.png" alt="Doa" onclick="selectImage('Doa', this)">
                    <p></p>
                </div>
            </div>

                    

            <div class="answer-container">
                <!-- Soalan dengan jawapan -->
                <h3 style="text-align: center; font-size: 18px;">Padankan Butang Jawapan Dengan Gambar:</h3>
                <div class="button-grid">
                    <button onclick="checkMatch('Masjid')">Masjid</button>
                    <button onclick="checkMatch('Solat')">Solat</button>
                    <button onclick="checkMatch('Zakat')">Zakat</button>
                    <button onclick="checkMatch('Al-Quran')">Al-Quran</button>
                    <button onclick="checkMatch('Doa')">Doa</button>
                    <button onclick="checkMatch('Haji')">Haji</button>
                    
                </div>
            </div>
        </div>

        <!-- Pop-up mesej -->
        <div class="popup-message" id="popupMessage"></div>
    </main>

    <script>
        const scoreElement = document.getElementById('score');
        let score = parseInt(sessionStorage.getItem('score')) || 0;
        let selectedImage = null;

        const requiredAnswers = ['Masjid', 'Al-Quran', 'Solat', 'Zakat', 'Haji', 'Doa'];
        const answeredQuestions = new Set();

        // Paparkan skor dari sesi penyimpanan
        scoreElement.textContent = score;

        function goToSettings() {
            window.location.href = 'settings.php';
        }

        function selectImage(imageName, imgElement) {
            const images = document.querySelectorAll('.image-box img');
            images.forEach(img => img.classList.remove('selected'));

            imgElement.classList.add('selected');
            selectedImage = imageName;

            setTimeout(() => {
                imgElement.classList.remove('selected');
            }, 1000);
        }

        function checkMatch(answer) {
            if (!selectedImage) {
                return;
            }

            if (selectedImage === answer) {
                answeredQuestions.add(answer);
                showPopupMessage('Tahniah! Jawapan betul!', true);

                if (answeredQuestions.size === requiredAnswers.length) {
                    score += 10;
                    scoreElement.textContent = score;
                    sessionStorage.setItem('score', score);

                    // Navigasi ke level3.php setelah semua jawapan dijawab
                    setTimeout(() => {
                        window.location.href = 'level3.php';
                    }, 2000);
                }
            } else {
                showPopupMessage('Anda salah! Sila buat lagi.', false);
            }

            selectedImage = null;
        }

        function showPopupMessage(message, isSuccess) {
            const popup = document.getElementById('popupMessage');
            popup.textContent = message;
            popup.style.backgroundColor = isSuccess ? '#2ECC71' : '#E74C3C';
            popup.style.color = '#fff';
            popup.style.display = 'block';

            setTimeout(() => {
                popup.style.display = 'none';
            }, 2000);
        }

        function selectImage(imageName, imgElement) {
    const images = document.querySelectorAll('.image-box img');
    
    // Remove highlight from all images
    images.forEach(img => img.classList.remove('selected'));

    // Highlight the selected image
    imgElement.classList.add('selected');
    selectedImage = imageName;

    // Automatically remove highlight after 2 seconds
    setTimeout(() => {
        imgElement.classList.remove('selected');
    }, 8000);
}


    </script>
</body>
</html>