<?php
// Assuming you already have a database connection in config.php
include '../../intro/config.php';

// Start session to retrieve logged-in user's data
session_start();

// Check if the user is logged in
if (isset($_SESSION['username'])) {
    // Get the username from the session
    $username = $_SESSION['username'];
    
    // Check if a score is provided in the POST request
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $score = isset($_POST['score']) ? $_POST['score'] : 0;

        // Check if the score is valid
        if (is_numeric($score)) {
            // Prepare and bind the query to insert the score into the database
            $stmt = $conn->prepare("INSERT INTO cirihaiwan (username, score) VALUES (?, ?)");
            $stmt->bind_param("si", $username, $score);

            // Execute the query
            if ($stmt->execute()) {
                // Return a success response
                echo json_encode(['success' => true]);
            } else {
                // Return an error response
                echo json_encode(['success' => false, 'message' => 'Database error']);
            }

            $stmt->close();
        } else {
            echo json_encode(['success' => false, 'message' => 'Invalid score data']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'User not logged in']);
}

$conn->close();
?>
