<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teka-Teki Haiwan</title>
    <style>
        /* General Styles */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background: url('background.jpg') no-repeat center center fixed;
            background-size: cover;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            overflow: hidden;
        }

        .container {
            text-align: center;
            max-width: 800px;
            margin: 0 auto;
            animation: fadeIn 1s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.8); }
            to { opacity: 1; transform: scale(1); }
        }

        /* Title Styles */
        .title {
            font-size: 3.5em;
            font-weight: 900;
            color: #007BFF;
            text-shadow: 0 4px 8px rgba(0, 0, 0, 0.3), 0 0 10px rgba(0, 123, 255, 0.7);
            text-transform: uppercase;
            margin-bottom: 20px;
            transition: transform 0.3s, text-shadow 0.3s, color 0.3s;
        }
        .title:hover {
            transform: scale(1.1);
            text-shadow: 0 6px 12px rgba(0, 0, 0, 0.5), 0 0 15px rgba(0, 123, 255, 0.9);
            color: #00CFFF;
        }

        /* Button Styles */
        .button {
            background-color: #4CAF50;
            color: white;
            padding: 15px 25px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 1.2em;
            transition: background-color 0.3s, transform 0.3s;
        }

        .button:hover { background-color: #45a049; transform: scale(1.1); }

        /* Question Container */
        .question-container {
            text-align: center;
            background: rgba(255, 255, 255, 0.7);
            padding: 20px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            width: 90%;
            max-width: 500px;
            margin: 20px auto;
        }

        /* Image Hover Effect */
        .answers img {
            width: 150px;
            height: auto;
            border-radius: 10px;
            cursor: pointer;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .answers img:hover {
            transform: scale(1.1) rotate(5deg);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.3);
        }

        /* Selected Image Glow */
        .selected {
            box-shadow: 0 0 15px 5px #B6F49D;
            transform: scale(1.1);
        }

        /* Hidden Page */
        .hidden { display: none; }

        /* Score Display */
        #score-display {
            position: absolute;
            top: 10px;
            right: 10px;
            background-color: green;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            font-size: 1.5em;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <!-- Score Display -->
    <div id="score-display">Markah: 0/100</div>

    <!-- Menu Section -->
    <div id="menu-page" class="container">
        <div class="title">Teka-Teki Haiwan</div>
        <button class="button" id="start-btn">🎮 Mulakan Permainan</button>
    </div>

    <!-- Game Section -->
    <div id="game-page" class="hidden container">
        <div class="question-container">
            <p id="question-text">Soalan akan dimuatkan...</p>
            <div id="answers-container" class="answers"></div>
        </div>
    </div>

    <!-- End Section -->
    <div id="end-page" class="hidden container">
        <h1 class="title">Permainan Tamat!</h1>
        <p id="final-score"></p>
        <button class="button" id="restart-btn">Kembali Ke Halaman Utama</button>
    </div>

    <script>
    // Game Data
    const questions = [
        {
            question: "Siapakah saya? Saya suka mengejar tikus.",
            correct: 0,
            options: [
                { img: "gif/kucing.gif", sound: "sound/kucing.mp3" },
                { img: "gif/burung.gif", sound: "sound/burung.mp3" },
                { img: "gif/kuda.gif", sound: "sound/kuda.mp3" }
            ]
        },
        {
            question: "Siapakah saya? Saya suka makan pisang.",
            correct: 1,
            options: [
                { img: "gif/gajah.gif", sound: "sound/gajah.mp3" },
                { img: "gif/monyet.gif", sound: "sound/monyet.mp3" },
                { img: "gif/lembu.gif", sound: "sound/lembu.mp3" }
            ]
        },
        {
            question: "Siapakah saya? Saya pandai melompat tinggi.",
            correct: 0,
            options: [
                { img: "gif/arnab.gif", sound: "sound/arnab.mp3" },
                { img: "gif/kuda.gif", sound: "sound/kuda.mp3" },
                { img: "gif/kambing.gif", sound: "sound/kambing.mp3" }
            ]
        },
        {
            question: "Siapakah saya? Saya berenang di air.",
            correct: 1,
            options: [
                { img: "gif/anjing.gif", sound: "sound/anjing.mp3" },
                { img: "gif/ikan.gif", sound: "sound/ikan.mp3" },
                { img: "gif/kuda.gif", sound: "sound/kuda.mp3" }
            ]
        },
        {
            question: "Siapakah saya? Saya pandai menyanyi pada waktu pagi.",
            correct: 1,
            options: [
                { img: "gif/arnab.gif", sound: "sound/arnab.mp3" },
                { img: "gif/burung.gif", sound: "sound/burung.mp3" },
                { img: "gif/lembu.gif", sound: "sound/lembu.mp3" }
            ]
        },
        {
            question: "Siapakah saya? Saya ada belang hitam putih.",
            correct: 2,
            options: [
                { img: "gif/arnab.gif", sound: "sound/arnab.mp3" },
                { img: "gif/ikan.gif", sound: "sound/ikan.mp3" },
                { img: "gif/zebra.gif", sound: "sound/zebra.mp3" }
            ]
        },
        {
            question: "Siapakah saya? Saya berubah dari ulat menjadi rama-rama.",
            correct: 2,
            options: [
                { img: "gif/kucing.gif", sound: "sound/kucing.mp3" },
                { img: "gif/burung.gif", sound: "sound/burung.mp3" },
                { img: "gif/ulat.gif", sound: "sound/ulat.mp3" }
            ]
        },
        {
            question: "Siapakah saya? Saya ada belalai panjang.",
            correct: 0,
            options: [
                { img: "gif/gajah.gif", sound: "sound/gajah.mp3" },
                { img: "gif/anjing.gif", sound: "sound/anjing.mp3" },
                { img: "gif/ikan.gif", sound: "sound/ikan.mp3" }
            ]
        },
        {
            question: "Siapakah saya? Saya kawan manusia yang setia.",
            correct: 2,
            options: [
                { img: "gif/kucing.gif", sound: "sound/kucing.mp3" },
                { img: "gif/kuda.gif", sound: "sound/kuda.mp3" },
                { img: "gif/anjing.gif", sound: "sound/anjing.mp3" }
            ]
        },
        {
            question: "Siapakah saya? Saya mengeluarkan bunyi 'moo'.",
            correct: 0,
            options: [
                { img: "gif/lembu.gif", sound: "sound/lembu.mp3" },
                { img: "gif/ikan.gif", sound: "sound/ikan.mp3" },
                { img: "gif/arnab.gif", sound: "sound/arnab.mp3" }
            ]
        }
    ];

        let currentQuestion = 0;
        let score = 0;

        const menuPage = document.getElementById("menu-page");
        const gamePage = document.getElementById("game-page");
        const endPage = document.getElementById("end-page");
        const startBtn = document.getElementById("start-btn");
        const restartBtn = document.getElementById("restart-btn");
        const questionText = document.getElementById("question-text");
        const answersContainer = document.getElementById("answers-container");
        const finalScore = document.getElementById("final-score");
        const scoreDisplay = document.getElementById("score-display");

        startBtn.addEventListener("click", () => {
            menuPage.classList.add("hidden");
            gamePage.classList.remove("hidden");
            loadQuestion();
        });

        restartBtn.addEventListener("click", () => {
    // Get the username from the logged-in user (replace with actual logic for getting the username)
    var username = 'exampleUsername'; // Replace with dynamic username from the session or other methods
    var scoreToSend = score;  // Current score to be sent

    // Send data to the server using Fetch API
    fetch('save_score.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'username=' + encodeURIComponent(username) + '&score=' + encodeURIComponent(scoreToSend)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('Data berjaya dimasukkan ke dalam database!');
        } else {
            alert('Terdapat masalah dalam menghantar data.');
        }
    })
    .catch(error => console.error('Error:', error));

    endPage.classList.add("hidden");
    menuPage.classList.remove("hidden");
    currentQuestion = 0;
    score = 0;
    updateScore();

    // Redirect to the desired page
    window.location.href = "../../murid5/indexTahun5.php";
});

        function loadQuestion() {
            const question = questions[currentQuestion];
            questionText.textContent = question.question;
            answersContainer.innerHTML = "";

            question.options.forEach((option, index) => {
                const img = document.createElement("img");
                img.src = option.img;
                img.addEventListener("click", () => handleAnswer(img, index));
                answersContainer.appendChild(img);
            });
        }

        function handleAnswer(img, index) {
    // Remove selected class from all images
    document.querySelectorAll(".answers img").forEach(el => el.classList.remove("selected"));
    img.classList.add("selected");

    const question = questions[currentQuestion];
    const audio = new Audio(question.options[index].sound);
    audio.play();

    if (index === question.correct) {
        // Correct answer, increment score
        score += 10;
        updateScore();
        setTimeout(() => {
            currentQuestion++;
            if (currentQuestion < questions.length) {
                loadQuestion();
            } else {
                endGame();
            }
        }, 1000);
    } else {
        // Incorrect answer, move to next question
        setTimeout(() => {
            currentQuestion++;
            if (currentQuestion < questions.length) {
                loadQuestion();
            } else {
                endGame();
            }
        }, 1000);
    }
}


        function updateScore() {
            scoreDisplay.textContent = `Markah: ${score}/${questions.length * 10}`;
        }

        function endGame() {
            gamePage.classList.add("hidden");
            endPage.classList.remove("hidden");
            finalScore.textContent = `Markah Akhir Anda: ${score}/${questions.length * 10}`;
        }
    </script>
</body>
</html>
