<?php
session_start();
include('../../intro/config.php'); // Ensure this file exists and is correct

// Validate inputs
if (!isset($_GET['username'], $_GET['score'])) {
    die("Ralat: Data tidak lengkap.");
}

$username = htmlspecialchars($_GET['username']);
$score = intval($_GET['score']);

if (empty($username) || $score < 0) {
    die("Ralat: Data tidak sah.");
}

$sql = "INSERT INTO bendahidupdanbukanhidup (username, score) VALUES (?, ?)";
$stmt = $conn->prepare($sql);

if (!$stmt) {
    die("Ralat penyediaan pernyataan: " . $conn->error);
}

$stmt->bind_param("si", $username, $score);

if ($stmt->execute()) {
    echo "Markah telah disimpan dengan jayanya!";
} else {
    echo "Ralat semasa menyimpan data: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>
