<?php
session_start(); // Memulakan sesi untuk mengakses data dalam sesi

// Memastikan skor ada dalam sesi atau menetapkan kepada 0 jika tiada
if (isset($_SESSION['score'])) {
    $score = $_SESSION['score']; // Mendapatkan skor terkini dari sesi
} else {
    $score = 0; // Jika tiada skor dalam sesi, tetapkan kepada 0
}

// Skor maksimum
$totalScore = 100;
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skor Permainan</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <h1>Permainan Selesai!</h1>
    <div id="score-display">
        <p>Skor Anda: <?= $score ?>/<?= $totalScore ?></p>
    </div>

    <!-- Button untuk menyimpan markah dan mulakan semula permainan -->
    <button onclick="saveScoreAndRestart()">Simpan Skor & Mulakan Semula</button>

    <script>
        // Fungsi untuk mendapatkan markah akhir dari sessionStorage atau PHP session
        function getFinalScore() {
            let score = sessionStorage.getItem('score');
            if (!score) {
                // Jika sessionStorage tiada, cuba dapatkan daripada PHP session
                score = '<?= $score ?>';
            }
            return score;
        }

        // Kemas kini paparan markah akhir
        const score = getFinalScore();
        document.getElementById('score-display').textContent = `Skor Anda: ${score}/100`;

        // Fungsi untuk menyimpan markah ke pangkalan data dan mulakan semula permainan
        function saveScoreAndRestart() {
            const tahap = 10; // Tahap permainan
            const username = '<?= $userName ?>'; // Mendapatkan nama pengguna daripada PHP

            fetch(`submit_score.php?score=${score}&username=${encodeURIComponent(username)}&tahap=${tahap}`)
                .then(response => response.text())
                .then(result => {
                    console.log(result); // Paparkan respons server untuk debugging
                    alert(result); // Tunjukkan mesej kepada pengguna
                    if (result.includes('jayanya')) {
                        sessionStorage.setItem('score', 0); // Tetapkan markah semula kepada 0
                        window.location.href = 'game.php'; // Halaman permainan semula
                    } else {
                        alert('Gagal menyimpan markah.');
                    }
                })
                .catch(error => {
                    console.error('Ralat menghantar markah:', error);
                    alert('Gagal menyimpan markah. Sila cuba lagi.');
                });
        }
    </script>
</body>
</html>
