<?php
// Include the database connection file
include('../../intro/config.php');

// Start the session to access the logged-in user's details
session_start();

// Ensure $score is obtained from the URL
if (isset($_GET['score'])) {
    $score = $_GET['score'];
} else {
    $score = 0; // Default value if score is not sent
}

// Check if the user is logged in (assuming the username is stored in the session)
if (isset($_SESSION['username'])) {
    $username = $_SESSION['username']; // Get the logged-in username
} else {
    // If not logged in, redirect to the login page
    header('Location: login.php');
    exit;
}

// Initialize variables for error handling
$error_message = '';
$success_message = '';

// Try to connect to the database and insert the score
if ($conn->connect_error) {
    $error_message = "Sambungan gagal: " . $conn->connect_error;
} else {
    // Prepared statement to prevent SQL injection
    $stmt = $conn->prepare("INSERT INTO akhlak (username, score) VALUES (?, ?)");
    if ($stmt) {
        $stmt->bind_param("si", $username, $score);
        if ($stmt->execute()) {
            $success_message = "Skor berjaya disimpan.";
        } else {
            $error_message = "Ralat semasa menyimpan skor: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $error_message = "Ralat penyediaan kueri: " . $conn->error;
    }
}

// Close the database connection
$conn->close();
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Skor Permainan</title>
    <link rel="stylesheet" href="style.css">    
</head>
<body class="body-score">

<div class="score-container">
    <h1 class="score">Permainan Akhlak Rasulullah SAW</h1>
    <p class="score">Skor anda: <?php echo htmlspecialchars($score); ?>/100</p>

    <!-- Display success or error messages -->
    <?php if (!empty($success_message)): ?>
        <div class="success-message" style="color: green; margin-bottom: 10px;">
            <?php echo $success_message; ?>
        </div>
    <?php elseif (!empty($error_message)): ?>
        <div class="error-message" style="color: red; margin-bottom: 10px;">
            <?php echo $error_message; ?>
        </div>
    <?php endif; ?>

    <!-- Button to go back to the main page -->
    <a href="../../murid5/indexTahun5.php" class="button score">Kembali Ke Halaman Utama</a>
</div>

</body>
</html>
