<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Permainan Akhlak Rasulullah SAW</title>
    <link rel="stylesheet" href="style.css">
    <script>
        let currentQuestion = 0;
        const totalQuestions = 10;
        let score = 0; // Initialize score

        const questions = [
            {
                question: "Kalau jumpa kawan, macam mana nak bercakap?",
                options: ["Cakap kasar", "Cakap elok-elok"],
                correctAnswer: "B",
                image: "img/soalan1.jpg"
            },
            {
                question: "Kalau nampak atuk atau nenek, apa kita buat?",
                options: ["Tak peduli", "Hormati dan sayang"],
                correctAnswer: "B",
                image: "img/soalan2.jpg"
            },
            {
                question: "Kalau ibu suruh kita kemas mainan, apa patut kita buat?",
                options: ["Tak dengar cakap", "Dengar dan tolong ibu"],
                correctAnswer: "B",
                image: "img/soalan3.jpg"
            },
            {
                question: "Kalau ada sampah, apa kita buat?",
                options: ["Buang merata-rata", "Buang dalam tong sampah"],
                correctAnswer: "B",
                image: "img/soalan4.jpg"
            },
            {
                question: "Kalau nampak cikgu, apa kita buat?",
                options: ["Tak bagi salam", "Beri salam sambil senyum"],
                correctAnswer: "B",
                image: "img/soalan5.png"
            },
            {
                question: "Kalau adik kecil menangis, apa kita buat?",
                options: ["Marah adik", "Sayang dan jaga adik"],
                correctAnswer: "B",
                image: "img/soalan6.jpg"
            },
            {
                question: "Kalau jiran perlukan tolong, apa kita buat?",
                options: ["Tak peduli", "Tolong jiran"],
                correctAnswer: "B",
                image: "img/soalan7.png"
            },
            {
                question: "Kalau nak cakap dengan kawan, macam mana nak cakap?",
                options: ["Cakap kasar", "Cakap baik-baik"],
                correctAnswer: "B",
                image: "img/soalan8.png"
            },
            {
                question: "Kalau kita sayang kawan, macam mana nak tunjuk?",
                options: ["Marah-marah", "Buat baik dengan mereka"],
                correctAnswer: "B",
                image: "img/soalan9.jpg"
            },
            {
                question: "Kalau nak makan, apa perlu kita buat?",
                options: ["Makan terus", "Baca Doa dahulu"],
                correctAnswer: "B",
                image: "img/soalan10.png"
            }
        ];

        function showQuestion(index) {
            const questionData = questions[index];
            document.getElementById("question-text").innerHTML = questionData.question;

            // Update question number display
            document.getElementById("question-number").textContent = `Soalan ${index + 1} daripada ${totalQuestions}`;

            // Display image if available
            if (questionData.image) {
                const imgElement = document.createElement("img");
                imgElement.src = questionData.image;
                imgElement.alt = "Soalan Image";
                imgElement.style.maxWidth = "60%";
                imgElement.style.margin = "10px 0";
                document.getElementById("image-container").innerHTML = ""; // Clear previous image
                document.getElementById("image-container").appendChild(imgElement);
            } else {
                document.getElementById("image-container").innerHTML = ""; // Clear if no image
            }

            const optionsContainer = document.getElementById("options-container");
            optionsContainer.innerHTML = ""; // Clear previous options

            questionData.options.forEach((option, i) => {
                const optionButton = document.createElement("button");
                optionButton.className = "button-game"; // Apply the 'button-game' class
                optionButton.textContent = option;
                optionButton.onclick = function () {
                    handleOptionClick(index, i);
                };
                optionsContainer.appendChild(optionButton);
            });
        }

        function handleOptionClick(questionIndex, optionIndex) {
    const selectedAnswer = String.fromCharCode(65 + optionIndex); // Convert 0,1,2 to A,B,C
    const messageContainer = document.getElementById("message-container");
    const optionsContainer = document.getElementById("options-container");

    // Disable all option buttons after one is clicked
    Array.from(optionsContainer.children).forEach((button) => {
        button.disabled = true;
    });

    if (selectedAnswer === questions[questionIndex].correctAnswer) {
        score += 10; 
        document.getElementById("score-display").textContent = `${score}/100`;
        messageContainer.textContent = "Tahniah! Anda berjaya, Mari Ke Soalan Seterusnya.";
        messageContainer.classList.remove("red");
        messageContainer.classList.add("green");

        // Hilangkan mesej selepas 1 saat
        setTimeout(() => {
            messageContainer.textContent = "";
            messageContainer.classList.remove("green");
            nextQuestion();
        }, 1000);

    } else {
        messageContainer.textContent = "Anda Salah. Jawapan yang betul adalah: " + questions[questionIndex].options[questions[questionIndex].correctAnswer.charCodeAt(0) - 65];
        messageContainer.classList.remove("green");
        messageContainer.classList.add("red");

        // Hilangkan mesej selepas 3 saat
        setTimeout(() => {
            messageContainer.textContent = "";
            messageContainer.classList.remove("red");
            nextQuestion(); // Pindah ke soalan seterusnya walaupun salah
        }, 1000);
    }
}

        function nextQuestion() {
            currentQuestion++;
            if (currentQuestion < totalQuestions) {
                showQuestion(currentQuestion);
    } else {
        // Redirect to score.php with the score as a query parameter
        window.location.href = `score.php?score=${score}`;
    }
}


        window.onload = () => {
            document.getElementById("score-display").textContent = `${score}/100`;
            showQuestion(currentQuestion);
        };
    </script>
</head>
<body>
    <div class="body-game">
    <div id="score-display">0/100</div>

    <div id="question-number" style="font-size: 1.2rem; margin: 10px 0;"></div>

        <br>

  <!-- Settings button as a link -->
<a href="setting.php" id="settings-button" class="settings-button">Tetapan</a>


        <div class="game-container" id="game-container">
        
            <div class="question-container">
                <h2 id="question-text"></h2>
                <div id="image-container"></div> <!-- Container for question image -->
                <div id="options-container"></div>
                <div id="message-container"></div>
            </div>
        </div>

        

        <div id="finish-message" style="display:none; text-align: center; margin-top: 20px;">
            <h2>Terima kasih kerana menyelesaikan permainan!</h2>
            <p>Anda telah menjawab semua soalan. Semoga bermanfaat.</p>
        </div>
    </div>
</body>
</html>
